/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBarracks;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class HireSpiesMessage
extends AbstractMessage<HireSpiesMessage, IMessage> {
    private int dimension;
    private int colonyId;

    public HireSpiesMessage() {
    }

    public HireSpiesMessage(@NotNull int colonyId, @NotNull int dimension) {
        this.colonyId = colonyId;
        this.dimension = dimension;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.dimension = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeInt(this.dimension);
    }

    @Override
    public void messageOnServerThread(HireSpiesMessage message, EntityPlayerMP player) {
        IColony colony = IColonyManager.getInstance().getColonyByDimension(message.colonyId, message.dimension);
        if (colony == null || !colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
            return;
        }
        if (InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)player.field_71071_by), stack -> stack.func_77973_b() == Items.field_151043_k) > BuildingBarracks.SPIES_GOLD_COST) {
            InventoryUtils.reduceStackInItemHandler(new InvWrapper((IInventory)player.field_71071_by), new ItemStack(Items.field_151043_k), BuildingBarracks.SPIES_GOLD_COST);
            colony.getRaiderManager().setSpiesEnabled(true);
            colony.markDirty();
        }
    }
}

