/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;

public class ItemParticleEffectMessage
extends AbstractMessage<ItemParticleEffectMessage, IMessage> {
    private static final Random RAND = new Random();
    private ItemStack stack;
    private double rotationPitch;
    private double rotationYaw;
    private double eyeHeight;
    private double posX;
    private double posY;
    private double posZ;

    public ItemParticleEffectMessage() {
    }

    public ItemParticleEffectMessage(ItemStack stack, double posX, double posY, double posZ, double rotationPitch, double rotationYaw, double eyeHeight) {
        this.stack = stack;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.rotationPitch = rotationPitch;
        this.rotationYaw = rotationYaw;
        this.eyeHeight = eyeHeight;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.rotationPitch = buf.readDouble();
        this.rotationYaw = buf.readDouble();
        this.eyeHeight = buf.readDouble();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeDouble(this.rotationPitch);
        buf.writeDouble(this.rotationYaw);
        buf.writeDouble(this.eyeHeight);
    }

    @Override
    protected void messageOnClientThread(ItemParticleEffectMessage message, MessageContext ctx) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        ItemStack localStack = message.stack;
        if (localStack.func_77975_n() == EnumAction.EAT) {
            for (int i = 0; i < 5; ++i) {
                Vec3d randomPos = new Vec3d((RAND.nextDouble() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                randomPos = randomPos.func_178789_a((float)(-message.rotationPitch * 0.01745329238474369));
                randomPos = randomPos.func_178785_b((float)(-message.rotationYaw * 0.01745329238474369));
                double d0 = -RAND.nextDouble() * 0.6 - 0.3;
                Vec3d randomOffset = new Vec3d((RAND.nextDouble() - 0.5) * 0.3, d0, 0.6);
                randomOffset = randomOffset.func_178789_a((float)(-message.rotationPitch * 0.01745329238474369));
                randomOffset = randomOffset.func_178785_b((float)(-message.rotationYaw * 0.01745329238474369));
                randomOffset = randomOffset.func_72441_c(message.posX, message.posY + message.eyeHeight, message.posZ);
                if (localStack.func_77981_g()) {
                    world.func_175688_a(EnumParticleTypes.ITEM_CRACK, randomOffset.field_72450_a, randomOffset.field_72448_b, randomOffset.field_72449_c, randomPos.field_72450_a, randomPos.field_72448_b + 0.05, randomPos.field_72449_c, new int[]{Item.func_150891_b((Item)localStack.func_77973_b()), localStack.func_77960_j()});
                    continue;
                }
                world.func_175688_a(EnumParticleTypes.ITEM_CRACK, randomOffset.field_72450_a, randomOffset.field_72448_b, randomOffset.field_72449_c, randomPos.field_72450_a, randomPos.field_72448_b + 0.05, randomPos.field_72449_c, new int[]{Item.func_150891_b((Item)localStack.func_77973_b())});
            }
        }
    }
}

