/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class RestartCitizenMessage
extends AbstractMessage<RestartCitizenMessage, IMessage> {
    private int colonyId;
    private int colonyDim;
    private int citizenID;

    public RestartCitizenMessage() {
    }

    public RestartCitizenMessage(@NotNull AbstractBuildingView building, int citizenID) {
        this.colonyId = building.getColony().getID();
        this.colonyDim = building.getColony().getDimension();
        this.citizenID = citizenID;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.colonyDim = buf.readInt();
        this.citizenID = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeInt(this.colonyDim);
        buf.writeInt(this.citizenID);
    }

    @Override
    public void messageOnServerThread(RestartCitizenMessage message, EntityPlayerMP player) {
        IColony colony = IColonyManager.getInstance().getColonyByDimension(message.colonyId, message.colonyDim);
        if (colony != null) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
                return;
            }
            ICitizenData citizen = colony.getCitizenManager().getCitizen(message.citizenID);
            citizen.scheduleRestart(player);
            LanguageHandler.sendPlayerMessage((EntityPlayer)player, "com.minecolonies.coremod.gui.hiring.restartMessage", citizen.getName());
        }
    }
}

