/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;

public class StreamParticleEffectMessage
extends AbstractMessage<StreamParticleEffectMessage, IMessage> {
    private static final Random RAND = new Random();
    private EnumParticleTypes type;
    private double sPosX;
    private double sPosY;
    private double sPosZ;
    private double ePosX;
    private double ePosY;
    private double ePosZ;
    private int stage;
    private int maxStage;

    public StreamParticleEffectMessage() {
    }

    public StreamParticleEffectMessage(Vec3d start, Vec3d end, EnumParticleTypes type, int stage, int maxStage) {
        this.sPosX = start.field_72450_a;
        this.sPosY = start.field_72448_b - 0.5;
        this.sPosZ = start.field_72449_c;
        this.ePosX = end.field_72450_a;
        this.ePosY = end.field_72448_b - 0.5;
        this.ePosZ = end.field_72449_c;
        this.stage = stage;
        this.maxStage = maxStage;
        this.type = type;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.sPosX = buf.readDouble();
        this.sPosY = buf.readDouble();
        this.sPosZ = buf.readDouble();
        this.ePosX = buf.readDouble();
        this.ePosY = buf.readDouble();
        this.ePosZ = buf.readDouble();
        this.stage = buf.readInt();
        this.maxStage = buf.readInt();
        this.type = EnumParticleTypes.values()[buf.readInt()];
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeDouble(this.sPosX);
        buf.writeDouble(this.sPosY);
        buf.writeDouble(this.sPosZ);
        buf.writeDouble(this.ePosX);
        buf.writeDouble(this.ePosY);
        buf.writeDouble(this.ePosZ);
        buf.writeInt(this.stage);
        buf.writeInt(this.maxStage);
        buf.writeInt(this.type.ordinal());
    }

    @Override
    protected void messageOnClientThread(StreamParticleEffectMessage message, MessageContext ctx) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Vec3d end = new Vec3d(message.ePosX, message.ePosY, message.ePosZ);
        double xDif = (message.sPosX - message.ePosX) / (double)message.maxStage;
        double yDif = (message.sPosY - message.ePosY) / (double)message.maxStage;
        double zDif = (message.sPosZ - message.ePosZ) / (double)message.maxStage;
        double curve = (double)message.maxStage / 3.0;
        for (int step = Math.max(0, message.stage - 1); step <= Math.min(message.maxStage, message.stage + 1); ++step) {
            double minDif = (double)Math.min(step, Math.abs(step - message.maxStage)) / curve;
            for (int i = 0; i < 10; ++i) {
                Vec3d randomPos = new Vec3d(RAND.nextDouble() * 0.1 + 0.1, RAND.nextDouble() * 0.1 + 0.1, RAND.nextDouble() * 0.1 + 0.1);
                Vec3d randomOffset = new Vec3d((RAND.nextDouble() - 0.5) * 0.1, (RAND.nextDouble() - 0.5) * 0.1, (RAND.nextDouble() - 0.5) * 0.1);
                world.func_175688_a(message.type, end.field_72450_a + randomOffset.field_72450_a + xDif * (double)step, end.field_72448_b + randomOffset.field_72448_b + yDif * (double)step + minDif, end.field_72449_c + randomOffset.field_72449_c + zDif * (double)step, randomPos.field_72450_a, randomPos.field_72448_b + 0.05, randomPos.field_72449_c, new int[0]);
            }
        }
    }
}

