/*
 * Decompiled with CFR 0.152.
 */
package am2.items;

import am2.items.IBoundItem;
import am2.items.ItemsCommonProxy;
import am2.playerextensions.ExtendedProperties;
import am2.spell.SpellHelper;
import am2.spell.SpellUtils;
import am2.texture.ResourceManager;
import am2.utility.InventoryUtilities;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class ItemBoundHoe
extends ItemHoe
implements IBoundItem {
    public ItemBoundHoe(Item.ToolMaterial par2ToolMaterial) {
        super(par2ToolMaterial);
        this.func_77656_e(0);
    }

    public ItemBoundHoe setUnlocalizedAndTextureName(String name) {
        this.func_77655_b(name);
        this.func_111206_d(name);
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = ResourceManager.RegisterTexture("bound_hoe", par1IconRegister);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack par1ItemStack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.rare;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_77616_k(ItemStack par1ItemStack) {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        this.UnbindItem(item, player, player.field_71071_by.field_70461_c);
        return false;
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int slotIndex, boolean par5) {
        if (par3Entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)par3Entity;
            if (player.field_71075_bZ.field_75098_d) {
                return;
            }
            ExtendedProperties props = ExtendedProperties.For((EntityLivingBase)player);
            if (props.getCurrentMana() + props.getBonusCurrentMana() < this.maintainCost()) {
                this.UnbindItem(par1ItemStack, (EntityPlayer)par3Entity, slotIndex);
                return;
            }
            props.deductMana(this.maintainCost());
            if (par1ItemStack.func_77960_j() > 0) {
                par1ItemStack.func_77972_a(-1, (EntityLivingBase)par3Entity);
            }
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        MovingObjectPosition mop = ItemsCommonProxy.spell.getMovingObjectPosition((EntityLivingBase)player, world, 4.0, true, false);
        if (mop != null && stack.func_77942_o()) {
            ItemStack castStack = this.getApplicationStack(stack);
            if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                SpellHelper.instance.applyStackStage(castStack, (EntityLivingBase)player, null, mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c, mop.field_72310_e, world, true, true, 0);
            } else if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && mop.field_72308_g instanceof EntityLivingBase) {
                SpellHelper.instance.applyStackStage(castStack, (EntityLivingBase)player, (EntityLivingBase)mop.field_72308_g, mop.field_72308_g.field_70165_t, mop.field_72308_g.field_70163_u, mop.field_72308_g.field_70161_v, mop.field_72310_e, world, true, true, 0);
            }
        }
        return super.func_77659_a(stack, world, player);
    }

    private ItemStack getApplicationStack(ItemStack boundStack) {
        ItemStack castStack = SpellUtils.instance.constructSpellStack(boundStack.func_77946_l());
        castStack = SpellUtils.instance.popStackStage(castStack);
        castStack = InventoryUtilities.replaceItem(castStack, ItemsCommonProxy.spell);
        return castStack;
    }

    @Override
    public float maintainCost() {
        if (this.field_77843_a == Item.ToolMaterial.STONE) {
            return 0.1f;
        }
        if (this.field_77843_a == Item.ToolMaterial.IRON) {
            return 0.4f;
        }
        if (this.field_77843_a == Item.ToolMaterial.EMERALD) {
            return 1.0f;
        }
        return 0.0f;
    }

    @Override
    public void UnbindItem(ItemStack itemstack, EntityPlayer player, int inventorySlot) {
        itemstack = InventoryUtilities.replaceItem(itemstack, ItemsCommonProxy.spell);
        player.field_71071_by.func_70299_a(inventorySlot, itemstack);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int face, float hitX, float hitY, float hitZ) {
        boolean b = super.func_77648_a(stack, player, world, x, y, z, face, hitX, hitY, hitZ);
        if (!player.func_70093_af() && b) {
            ItemStack castStack = this.getApplicationStack(stack);
            SpellHelper.instance.applyStackStage(castStack, (EntityLivingBase)player, null, x, y, z, face, world, true, true, 0);
        }
        return b;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77629_n_() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }
}

