/*
 * Decompiled with CFR 0.152.
 */
package am2.particles;

import am2.AMCore;
import am2.api.math.AMVector3;
import am2.buffs.BuffList;
import am2.codechicken.LightningBolt;
import am2.network.AMDataReader;
import am2.particles.AMBeam;
import am2.particles.AMLineArc;
import am2.particles.AMParticle;
import am2.particles.ParticleArcToEntity;
import am2.particles.ParticleArcToPoint;
import am2.particles.ParticleController;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleFleeEntity;
import am2.particles.ParticleFloatUpward;
import am2.particles.ParticleGrow;
import am2.particles.ParticleManagerServer;
import am2.particles.ParticleMoveOnHeading;
import am2.particles.ParticleOrbitEntity;
import am2.particles.ParticleOrbitPoint;
import am2.particles.ParticlePendulum;
import am2.particles.ParticleRenderer;
import am2.particles.ribbon.AMRibbon;
import am2.playerextensions.ExtendedProperties;
import am2.utility.MathUtilities;
import cpw.mods.fml.common.FMLCommonHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class ParticleManagerClient
extends ParticleManagerServer {
    public static final byte PKT_BOLT_ENT_ENT = 64;
    public static final byte PKT_BOLT_PT_PT = 63;
    public static final byte PKT_BEAM_ENT_ENT = 62;
    public static final byte PKT_BEAM_PT_PT = 61;
    private final ParticleRenderer particleRenderer = new ParticleRenderer();

    public AMParticle spawn(World world, String name, double x, double y, double z) {
        AMParticle particle = new AMParticle(world, x, y, z);
        particle.SetParticleTextureByName(name);
        this.particleRenderer.addAMParticle(particle);
        return particle;
    }

    public AMLineArc spawn(World world, String name, double x, double y, double z, double targetX, double targetY, double targetZ) {
        AMLineArc arc = new AMLineArc(world, x, y, z, targetX, targetY, targetZ, name);
        this.particleRenderer.addArcEffect(arc);
        return arc;
    }

    public AMLineArc spawn(World world, String name, double x, double y, double z, Entity target) {
        AMLineArc arc = new AMLineArc(world, x, y, z, target, name);
        this.particleRenderer.addArcEffect(arc);
        return arc;
    }

    public AMLineArc spawn(World world, String name, Entity source, Entity target) {
        AMLineArc arc = new AMLineArc(world, source, target, name);
        this.particleRenderer.addArcEffect(arc);
        return arc;
    }

    public void registerEventHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)this.particleRenderer);
        FMLCommonHandler.instance().bus().register((Object)this.particleRenderer);
    }

    @Override
    public void BoltFromEntityToEntity(World world, Entity caster, Entity source, Entity target, int damage, int type, int color) {
        double xx = target.field_70165_t;
        double yy = target.field_70163_u + (double)target.func_70047_e();
        double zz = target.field_70161_v;
        double px = source.field_70165_t;
        double py = source.field_70163_u + (double)source.func_70047_e();
        double pz = source.field_70161_v;
        px -= (double)(MathHelper.func_76134_b((float)(source.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        py -= 0.1000000014901161;
        pz -= (double)(MathHelper.func_76126_a((float)(source.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        AMVector3 vec3d = MathUtilities.getLook(source, 1.0f);
        LightningBolt bolt = new LightningBolt(world, px += (double)vec3d.x * 0.25, py += (double)vec3d.y * 0.25, pz += (double)vec3d.z * 0.25, xx, target.field_70121_D.field_72338_b + (double)(target.field_70131_O / 2.0f), zz, world.field_73012_v.nextLong(), 6, 0.3f, 6);
        bolt.defaultFractal();
        bolt.setSourceEntity(caster);
        bolt.setType(type);
        bolt.setDamage(0);
        bolt.setOverrideColor(color);
        bolt.finalizeBolt();
    }

    @Override
    public void BoltFromPointToPoint(World world, double startX, double startY, double startZ, double endX, double endY, double endZ) {
        this.BoltFromPointToPoint(world, startX, startY, startZ, endX, endY, endZ, 1, -1);
    }

    @Override
    public void BoltFromEntityToPoint(World world, Entity source, double endX, double endY, double endZ) {
        this.BoltFromEntityToPoint(world, source, endX, endY, endZ, 0, -1);
    }

    @Override
    public void BoltFromEntityToPoint(World world, Entity source, double endX, double endY, double endZ, int type, int color) {
        this.BoltFromPointToPoint(world, source.field_70165_t, source.field_70163_u + (double)source.func_70047_e(), source.field_70161_v, endX, endY, endZ, type, color);
    }

    @Override
    public void BoltFromEntityToEntity(World world, Entity caster, Entity source, Entity target, int damage) {
        this.BoltFromEntityToEntity(world, caster, source, target, damage, 1, -1);
    }

    @Override
    public void BoltFromPointToPoint(World world, double startX, double startY, double startZ, double endX, double endY, double endZ, int type, int color) {
        if (AMCore.config.NoGFX()) {
            return;
        }
        LightningBolt bolt = new LightningBolt(world, startX, startY, startZ, endX, endY, endZ, world.field_73012_v.nextLong(), 6, 0.3f, 6);
        bolt.defaultFractal();
        bolt.setSourceEntity(null);
        bolt.setType(type);
        bolt.setDamage(0);
        bolt.finalizeBolt();
    }

    @Override
    public Object BeamFromEntityToEntity(World world, Entity caster, Entity source, Entity target, int damage, int color) {
        if (AMCore.config.NoGFX()) {
            return null;
        }
        double xx = target.field_70165_t;
        double yy = target.field_70163_u + (double)target.func_70047_e();
        double zz = target.field_70161_v;
        double px = source.field_70165_t;
        double py = source.field_70163_u + (double)source.func_70047_e();
        double pz = source.field_70161_v;
        px -= (double)(MathHelper.func_76134_b((float)(source.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        py -= 0.1000000014901161;
        pz -= (double)(MathHelper.func_76126_a((float)(source.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        AMVector3 vec3d = MathUtilities.getLook(source, 1.0f);
        AMBeam fx = new AMBeam(world, px += (double)vec3d.x * 0.25, py += (double)vec3d.y * 0.25, pz += (double)vec3d.z * 0.25, xx, target.field_70121_D.field_72338_b + (double)(target.field_70131_O / 2.0f), zz);
        fx.setRGBColor(color);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        return fx;
    }

    @Override
    public Object BeamFromPointToPoint(World world, double startX, double startY, double startZ, double endX, double endY, double endZ, int color) {
        if (AMCore.config.NoGFX()) {
            return null;
        }
        AMBeam fx = new AMBeam(world, startX, startY, startZ, endX, endY, endZ);
        fx.setRGBColor(color);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        return fx;
    }

    @Override
    public Object BeamFromPointToPoint(World world, double startX, double startY, double startZ, double endX, double endY, double endZ) {
        return this.BeamFromPointToPoint(world, startX, startY, startZ, endX, endY, endZ, 0xFFFFFF);
    }

    @Override
    public Object BeamFromEntityToPoint(World world, Entity source, double endX, double endY, double endZ) {
        return this.BeamFromEntityToPoint(world, source, endX, endY, endZ, 0xFFFFFF);
    }

    @Override
    public Object BeamFromEntityToPoint(World world, Entity source, double endX, double endY, double endZ, int color) {
        if (!(source instanceof EntityPlayer) || source == AMCore.proxy.getLocalPlayer()) {
            return this.BeamFromPointToPoint(world, source.field_70165_t, source.field_70163_u, source.field_70161_v, endX, endY, endZ, color);
        }
        return this.BeamFromPointToPoint(world, source.field_70165_t, source.field_70163_u + (double)source.func_70047_e() - (double)0.2f, source.field_70161_v, endX, endY, endZ, color);
    }

    @Override
    public Object BeamFromEntityToEntity(World world, Entity caster, Entity source, Entity target, int damage) {
        return this.BeamFromEntityToEntity(world, caster, source, target, damage, 0xFFFFFF);
    }

    @Override
    public void RibbonFromEntityToEntity(World world, Entity caster, Entity source, Entity target, int damage, int type) {
        double xx = target.field_70165_t;
        double yy = target.field_70163_u + (double)target.func_70047_e();
        double zz = target.field_70161_v;
        double px = source.field_70165_t;
        double py = source.field_70163_u + (double)source.func_70047_e();
        double pz = source.field_70161_v;
        px -= (double)(MathHelper.func_76134_b((float)(source.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        py -= 0.1000000014901161;
        pz -= (double)(MathHelper.func_76126_a((float)(source.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        AMVector3 vec3d = MathUtilities.getLook(source, 1.0f);
        AMRibbon ribbon = new AMRibbon(world, 0.5f, 0.05f, px += (double)vec3d.x * 0.25, py += (double)vec3d.y * 0.25, pz += (double)vec3d.z * 0.25);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)ribbon);
    }

    @Override
    public void RibbonFromPointToPoint(World world, double startX, double startY, double startZ, double endX, double endY, double endZ) {
        this.RibbonFromPointToPoint(world, startX, startY, startZ, endX, endY, endZ, 1);
    }

    @Override
    public void RibbonFromEntityToPoint(World world, Entity source, double endX, double endY, double endZ) {
        this.RibbonFromEntityToPoint(world, source, endX, endY, endZ, 0);
    }

    @Override
    public void RibbonFromEntityToPoint(World world, Entity source, double endX, double endY, double endZ, int type) {
        this.RibbonFromPointToPoint(world, source.field_70165_t, source.field_70163_u, source.field_70161_v, endX, endY, endZ, 0);
    }

    @Override
    public void RibbonFromEntityToEntity(World world, Entity caster, Entity source, Entity target, int damage) {
        this.RibbonFromEntityToEntity(world, caster, source, target, damage, 1);
    }

    @Override
    public void RibbonFromPointToPoint(World world, double startX, double startY, double startZ, double endX, double endY, double endZ, int type) {
        if (AMCore.config.NoGFX()) {
            return;
        }
        AMRibbon ribbon = new AMRibbon(world, 0.5f, 0.05f, startX, startY, startZ);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)ribbon);
    }

    @Override
    public void handleClientPacketData(World world, byte[] data) {
        AMDataReader rdr = new AMDataReader(data);
        byte sub_id = rdr.getByte();
        int type = 1;
        switch (sub_id) {
            case 64: {
                int casterID = rdr.getInt();
                int sourceID = rdr.getInt();
                int targetID = rdr.getInt();
                int damage = rdr.getInt();
                type = rdr.getInt();
                int color = rdr.getInt();
                Entity caster = world.func_73045_a(casterID);
                Entity source = world.func_73045_a(sourceID);
                Entity target = world.func_73045_a(targetID);
                if (caster == null || source == null || target == null) {
                    return;
                }
                this.BoltFromEntityToEntity(world, caster, source, target, damage, type, color);
                break;
            }
            case 63: {
                double startX = rdr.getDouble();
                double startY = rdr.getDouble();
                double startZ = rdr.getDouble();
                double endX = rdr.getDouble();
                double endY = rdr.getDouble();
                double endZ = rdr.getDouble();
                type = rdr.getInt();
                int color = rdr.getInt();
                this.BoltFromPointToPoint(world, startX, startY, startZ, endX, endY, endZ, type, color);
                break;
            }
            case 62: {
                int casterID = rdr.getInt();
                int sourceID = rdr.getInt();
                int targetID = rdr.getInt();
                int damage = rdr.getInt();
                type = rdr.getInt();
                Entity caster = world.func_73045_a(casterID);
                Entity source = world.func_73045_a(sourceID);
                Entity target = world.func_73045_a(targetID);
                if (caster == null || source == null || target == null) {
                    return;
                }
                this.BeamFromEntityToEntity(world, caster, source, target, damage, type);
                break;
            }
            case 61: {
                double startX = rdr.getDouble();
                double startY = rdr.getDouble();
                double startZ = rdr.getDouble();
                double endX = rdr.getDouble();
                double endY = rdr.getDouble();
                double endZ = rdr.getDouble();
                type = rdr.getInt();
                this.BeamFromPointToPoint(world, startX, startY, startZ, endX, endY, endZ, type);
                break;
            }
            case 59: {
                double startX = rdr.getDouble();
                double startY = rdr.getDouble();
                double startZ = rdr.getDouble();
                double endX = rdr.getDouble();
                double endY = rdr.getDouble();
                double endZ = rdr.getDouble();
                type = rdr.getInt();
                this.RibbonFromPointToPoint(world, startX, startY, startZ, endX, endY, endZ, type);
                break;
            }
            case 60: {
                int casterID = rdr.getInt();
                int sourceID = rdr.getInt();
                int targetID = rdr.getInt();
                int damage = rdr.getInt();
                type = rdr.getInt();
                Entity caster = world.func_73045_a(casterID);
                Entity source = world.func_73045_a(sourceID);
                Entity target = world.func_73045_a(targetID);
                if (caster == null || source == null || target == null) {
                    return;
                }
                this.RibbonFromEntityToEntity(world, caster, source, target, damage, type);
                break;
            }
            case 58: {
                String name = rdr.getString();
                double startX = rdr.getDouble();
                double startY = rdr.getDouble();
                double startZ = rdr.getDouble();
                double endX = rdr.getDouble();
                double endY = rdr.getDouble();
                double endZ = rdr.getDouble();
                this.spawn(world, name, startX, startY, startZ, endX, endY, endZ);
                break;
            }
            case 57: {
                String name = rdr.getString();
                double startX = rdr.getDouble();
                double startY = rdr.getDouble();
                double startZ = rdr.getDouble();
                int targetID = rdr.getInt();
                Entity target = world.func_73045_a(targetID);
                if (target == null) {
                    return;
                }
                this.spawn(world, name, startX, startY, startZ, target);
                break;
            }
            case 56: {
                String name = rdr.getString();
                int sourceID = rdr.getInt();
                int targetID = rdr.getInt();
                Entity source = world.func_73045_a(sourceID);
                Entity target = world.func_73045_a(targetID);
                if (source == null || target == null) {
                    return;
                }
                this.spawn(world, name, source, target);
            }
        }
    }

    @Override
    public void spawnAuraParticles(EntityLivingBase ent) {
        if (!ent.field_70170_p.field_72995_K) {
            return;
        }
        int particleIndex = 15;
        int particleBehaviour = 0;
        float particleScale = 0.0f;
        float particleAlpha = 0.0f;
        boolean particleDefaultColor = true;
        boolean particleRandomColor = true;
        int particleColor = 0xFFFFFF;
        int particleQuantity = 2;
        float particleSpeed = 0.02f;
        if (Minecraft.func_71410_x().field_71439_g == ent) {
            particleIndex = AMCore.config.getAuraIndex();
            particleBehaviour = AMCore.config.getAuraBehaviour();
            particleScale = AMCore.config.getAuraScale() / 10.0f;
            particleAlpha = AMCore.config.getAuraAlpha();
            particleDefaultColor = AMCore.config.getAuraColorDefault();
            particleRandomColor = AMCore.config.getAuraColorRandom();
            particleColor = AMCore.config.getAuraColor();
            particleQuantity = AMCore.config.getAuraQuantity();
            particleSpeed = AMCore.config.getAuraSpeed() / 10.0f;
        } else {
            ExtendedProperties entProperties = ExtendedProperties.For(ent);
            particleIndex = entProperties.getAuraIndex();
            particleBehaviour = entProperties.getAuraBehaviour();
            particleScale = entProperties.getAuraScale() / 10.0f;
            particleAlpha = entProperties.getAuraAlpha();
            particleDefaultColor = entProperties.getAuraColorDefault();
            particleRandomColor = entProperties.getAuraColorRandomize();
            particleColor = entProperties.getAuraColor();
            particleQuantity = entProperties.getAuraQuantity();
            particleSpeed = entProperties.getAuraSpeed() / 10.0f;
        }
        if (particleIndex == 31) {
            particleScale /= 10.0f;
        }
        if (ent.field_70170_p.field_72995_K && ent instanceof EntityPlayer && AMCore.proxy.playerTracker.hasAA((EntityPlayer)ent) && (Minecraft.func_71410_x().field_71439_g != ent || Minecraft.func_71410_x().field_71474_y.field_74320_O > 0)) {
            if (AMParticle.particleTypes[particleIndex].startsWith("lightning_bolts")) {
                int type = Integer.parseInt(new String(new char[]{AMParticle.particleTypes[particleIndex].charAt(AMParticle.particleTypes[particleIndex].length() - 1)}));
                if (ent.field_70170_p.field_73012_v.nextInt(100) < 90) {
                    this.BoltFromPointToPoint(ent.field_70170_p, ent.field_70165_t + (double)(ent.field_70170_p.field_73012_v.nextFloat() - 0.5f), ent.field_70163_u + (double)ent.func_70047_e() - (double)ent.field_70131_O + (double)(ent.field_70170_p.field_73012_v.nextFloat() * ent.field_70131_O), ent.field_70161_v + (double)(ent.field_70170_p.field_73012_v.nextFloat() - 0.5f), ent.field_70165_t + (double)(ent.field_70170_p.field_73012_v.nextFloat() - 0.5f), ent.field_70163_u + (double)ent.func_70047_e() - (double)ent.field_70131_O + (double)(ent.field_70170_p.field_73012_v.nextFloat() * ent.field_70131_O), ent.field_70161_v + (double)(ent.field_70170_p.field_73012_v.nextFloat() - 0.5f), type, -1);
                } else {
                    this.BoltFromPointToPoint(ent.field_70170_p, ent.field_70165_t, ent.field_70163_u + (double)ent.func_70047_e() - 0.4, ent.field_70161_v, ent.field_70165_t + (double)(ent.field_70170_p.field_73012_v.nextFloat() * 10.0f - 5.0f), ent.field_70163_u + (double)(ent.field_70170_p.field_73012_v.nextFloat() * 10.0f - 5.0f), ent.field_70161_v + (double)(ent.field_70170_p.field_73012_v.nextFloat() * 10.0f - 5.0f), type, -1);
                }
            } else {
                boolean offset = false;
                block11: for (int i = 0; i < particleQuantity; ++i) {
                    AMParticle effect = this.spawn(ent.field_70170_p, AMParticle.particleTypes[particleIndex], ent.field_70165_t + (double)(ent.field_70170_p.field_73012_v.nextFloat() - 0.5f), ent.field_70163_u + (double)ent.func_70047_e() - 0.5 + (double)offset - (double)ent.field_70170_p.field_73012_v.nextFloat() * 0.5, ent.field_70161_v + (double)(ent.field_70170_p.field_73012_v.nextFloat() - 0.5f));
                    if (effect == null) continue;
                    effect.setIgnoreMaxAge(false);
                    effect.setMaxAge(40);
                    effect.setParticleScale(particleScale);
                    effect.SetParticleAlpha(particleAlpha);
                    effect.field_70145_X = false;
                    if (!particleDefaultColor) {
                        if (particleRandomColor) {
                            effect.setRGBColorF(ent.field_70170_p.field_73012_v.nextFloat(), ent.field_70170_p.field_73012_v.nextFloat(), ent.field_70170_p.field_73012_v.nextFloat());
                        } else {
                            effect.setRGBColorI(particleColor);
                        }
                    }
                    switch (particleBehaviour) {
                        case 0: {
                            effect.AddParticleController(new ParticleFadeOut(effect, 1, false).setFadeSpeed(particleSpeed));
                            continue block11;
                        }
                        case 1: {
                            effect.AddParticleController(new ParticleFloatUpward(effect, 0.2f, particleSpeed, 1, false));
                            continue block11;
                        }
                        case 2: {
                            effect.AddParticleController(new ParticleFloatUpward(effect, 0.2f, -particleSpeed, 1, false));
                            continue block11;
                        }
                        case 3: {
                            effect.AddParticleController(new ParticleOrbitEntity(effect, (Entity)ent, particleSpeed, 1, false));
                            continue block11;
                        }
                        case 4: {
                            effect.AddParticleController(new ParticleArcToEntity(effect, 1, (Entity)ent, false).generateControlPoints().SetSpeed(particleSpeed));
                            continue block11;
                        }
                        case 5: {
                            effect.AddParticleController(new ParticleFleeEntity(effect, (Entity)ent, particleSpeed, 2.0, 1, false));
                            continue block11;
                        }
                        case 6: {
                            effect.AddParticleController(new ParticleMoveOnHeading(effect, ent.field_70177_z + 90.0f, ent.field_70125_A, particleSpeed, 1, false));
                            continue block11;
                        }
                        case 7: {
                            effect.AddParticleController(new ParticlePendulum(effect, 0.2f, particleSpeed, 1, false));
                            continue block11;
                        }
                        case 8: {
                            effect.AddParticleController(new ParticleGrow(effect, particleSpeed, 1, false));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void spawnBuffParticles(EntityLivingBase entityliving) {
        World world = entityliving.field_70170_p;
        if (!world.field_72995_K) {
            return;
        }
        if (entityliving == Minecraft.func_71410_x().field_71439_g) {
            if (entityliving.func_82165_m(BuffList.trueSight.field_76415_H) && entityliving.field_70173_aa % 20 == 0) {
                int radius = 5;
                for (int i = -radius; i <= radius; ++i) {
                    for (int j = -radius; j <= radius; ++j) {
                        for (int k = -radius; k <= radius; ++k) {
                            AMParticle effect;
                            if (entityliving.field_70170_p.func_147439_a((int)entityliving.field_70165_t + i, (int)entityliving.field_70163_u + j, (int)entityliving.field_70161_v + k) != Blocks.field_150350_a || entityliving.field_70170_p.func_72957_l((int)entityliving.field_70165_t + i, (int)entityliving.field_70163_u + j, (int)entityliving.field_70161_v + k) > 7 || (effect = this.spawn(world, "hr_sparkles_1", (double)((int)entityliving.field_70165_t - 1 + i) + world.field_73012_v.nextDouble() * 3.0, (double)((int)entityliving.field_70163_u - 1 + j) + world.field_73012_v.nextDouble() * 3.0, (double)((int)entityliving.field_70161_v - 1 + k) + world.field_73012_v.nextDouble() * 3.0)) == null) continue;
                            effect.setRGBColorF(world.field_73012_v.nextFloat() * 0.4f + 0.3f, 0.6f, world.field_73012_v.nextFloat() * 0.4f + 0.6f);
                            effect.setIgnoreMaxAge(false);
                            effect.setMaxAge(40);
                            effect.AddParticleController(new ParticleFloatUpward(effect, 0.01f, 0.01f, 1, false));
                            effect.AddParticleController(new ParticleFadeOut(effect, 2, false).setFadeSpeed(0.01f));
                        }
                    }
                }
            }
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                return;
            }
        }
    }

    @Override
    public ParticleController createDefaultParticleController(int type, Object eff, AMVector3 location, float modifier, int meta) {
        AMParticle effect = (AMParticle)((Object)eff);
        switch (type) {
            default: {
                return new ParticleFadeOut(effect, 1, false).setFadeSpeed(0.02f * modifier);
            }
            case 1: {
                return new ParticleFloatUpward(effect, 0.01f, 0.03f * modifier, 1, false);
            }
            case 2: {
                return new ParticleFloatUpward(effect, 0.01f, -0.03f * modifier, 1, false);
            }
            case 3: {
                return new ParticleOrbitPoint(effect, location.x, location.y, location.z, 1, false).SetOrbitSpeed(0.05f * modifier);
            }
            case 4: {
                return new ParticleArcToPoint(effect, 1, location.x, location.y, location.z, false).generateControlPoints().SetSpeed(0.02f * modifier);
            }
            case 5: {
                return new ParticleMoveOnHeading(effect, effect.field_70170_p.field_73012_v.nextInt(360), 0.0, 0.02f * modifier, 1, false);
            }
            case 6: 
        }
        if ((meta & 0xFFFFFFF7) == 3) {
            meta &= 0xFFFFFFFD;
        } else if ((meta & 0xFFFFFFF7) == 1) {
            meta |= 2;
        }
        return new ParticleMoveOnHeading(effect, (meta & 0xFFFFFFF7) * 90, 0.0, 0.02f * modifier, 1, false);
    }

    @Override
    public ParticleController createDefaultParticleController(int type, Object eff, EntityLivingBase ent) {
        AMParticle effect = (AMParticle)((Object)eff);
        switch (type) {
            default: {
                return new ParticleFadeOut(effect, 1, false).setFadeSpeed(0.02f);
            }
            case 1: {
                return new ParticleFloatUpward(effect, 0.2f, 0.03f, 1, false);
            }
            case 2: {
                return new ParticleFloatUpward(effect, 0.2f, -0.03f, 1, false);
            }
            case 3: {
                return new ParticleOrbitEntity(effect, (Entity)ent, 0.05f, 1, false);
            }
            case 4: {
                return new ParticleArcToEntity(effect, 1, (Entity)ent, false).generateControlPoints();
            }
            case 5: {
                return new ParticleFleeEntity(effect, (Entity)ent, 0.05f, 2.0, 1, false);
            }
            case 6: 
        }
        return new ParticleMoveOnHeading(effect, ent.field_70177_z + 90.0f, ent.field_70125_A, 0.05f, 1, false);
    }
}

