/*
 * Decompiled with CFR 0.152.
 */
package am2.particles.ribbon;

import am2.api.math.AMVector3;
import am2.particles.AMParticleIcons;
import am2.particles.ribbon.Quad3D;
import java.util.LinkedList;

public class RibbonCurve {
    float ribbonWidth;
    float resolution;
    AMVector3 startPt;
    AMVector3 endPt;
    AMVector3 controlPt;
    int stepId;
    float ribbonColor = 0.0f;
    LinkedList quads;

    RibbonCurve(AMVector3 pStartPt, AMVector3 pEndPt, AMVector3 pControlPt, float pwidth, float presolution, float pcolor) {
        this.startPt = pStartPt;
        this.endPt = pEndPt;
        this.controlPt = pControlPt;
        this.resolution = presolution;
        this.ribbonWidth = pwidth;
        this.stepId = 0;
        this.ribbonColor = pcolor;
        this.quads = new LinkedList();
    }

    void draw() {
        int size = this.quads.size();
        for (int i = 0; i < size; ++i) {
            Quad3D q = (Quad3D)this.quads.get(i);
            q.draw();
        }
    }

    void removeSegment() {
        if (this.quads.size() > 1) {
            this.quads.removeFirst();
        }
    }

    void addSegment() {
        float t = (float)this.stepId / this.resolution;
        AMVector3 p0 = this.getOffsetPoint(t, 0.0f);
        AMVector3 p3 = this.getOffsetPoint(t, this.ribbonWidth);
        ++this.stepId;
        if ((float)this.stepId > this.resolution) {
            return;
        }
        t = (float)this.stepId / this.resolution;
        AMVector3 p1 = this.getOffsetPoint(t, 0.0f);
        AMVector3 p2 = this.getOffsetPoint(t, this.ribbonWidth);
        Quad3D q = new Quad3D(p0, p1, p2, p3, AMParticleIcons.instance.getIconByName("symbols"));
        this.quads.add(q);
    }

    AMVector3 getOffsetPoint(float t, float k) {
        AMVector3 p0 = this.startPt;
        AMVector3 p1 = this.controlPt;
        AMVector3 p2 = this.endPt;
        float xt = (1.0f - t) * (1.0f - t) * p0.x + 2.0f * t * (1.0f - t) * p1.x + t * t * p2.x;
        float yt = (1.0f - t) * (1.0f - t) * p0.y + 2.0f * t * (1.0f - t) * p1.y + t * t * p2.y;
        float zt = (1.0f - t) * (1.0f - t) * p0.z + 2.0f * t * (1.0f - t) * p1.z + t * t * p2.z;
        float xd = t * (p0.x - 2.0f * p1.x + p2.x) - p0.x + p1.x;
        float yd = t * (p0.y - 2.0f * p1.y + p2.y) - p0.y + p1.y;
        float zd = t * (p0.z - 2.0f * p1.z + p2.z) - p0.z + p1.z;
        float dd = (float)Math.pow(xd * xd + yd * yd + zd * zd, 0.0);
        return new AMVector3(xt + k * yd / dd, yt - k * xd / dd, zt - k * xd / dd);
    }
}

