/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.RitualShapeHelper;
import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.spell.component.interfaces.IRitualInteraction;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.SpellModifiers;
import am2.buffs.BuffEffectCharmed;
import am2.buffs.BuffList;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.ParticleFloatUpward;
import am2.playerextensions.ExtendedProperties;
import am2.spell.SpellUtils;
import am2.utility.EntityUtilities;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class Charm
implements ISpellComponent,
IRitualInteraction {
    @Override
    public int getID() {
        return 59;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[3];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 14);
        objectArray[1] = new ItemStack((Item)ItemsCommonProxy.essence, 1, 8);
        objectArray[2] = new ItemStack((Item)ItemsCommonProxy.crystalPhylactery, 1, 0);
        return objectArray;
    }

    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return false;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        int z;
        int y;
        if (!(target instanceof EntityCreature) || ((EntityCreature)target).func_70644_a((Potion)BuffList.charmed) || EntityUtilities.isSummon((EntityLivingBase)((EntityCreature)target))) {
            return false;
        }
        int duration = SpellUtils.instance.getModifiedInt_Mul(600, stack, caster, target, world, 0, SpellModifiers.DURATION);
        duration = SpellUtils.instance.modifyDurationBasedOnArmor(caster, duration);
        int x = (int)Math.floor(target.field_70165_t);
        if (RitualShapeHelper.instance.checkForRitual(this, world, x, y = (int)Math.floor(target.field_70163_u), z = (int)Math.floor(target.field_70161_v)) != null) {
            duration += 3600 * (SpellUtils.instance.countModifiers(SpellModifiers.BUFF_POWER, stack, 0) + 1);
            RitualShapeHelper.instance.consumeRitualReagents(this, world, x, y, z);
        }
        if (target instanceof EntityAnimal) {
            ((EntityAnimal)target).func_146082_f(null);
            return true;
        }
        if (ExtendedProperties.For(caster).getCanHaveMoreSummons()) {
            if (caster instanceof EntityPlayer) {
                if (target instanceof EntityCreature) {
                    BuffEffectCharmed charmBuff = new BuffEffectCharmed(duration, 1);
                    charmBuff.setCharmer(caster);
                    ((EntityCreature)target).func_70690_d((PotionEffect)charmBuff);
                }
                return true;
            }
            if (caster instanceof EntityLiving) {
                if (target instanceof EntityCreature) {
                    BuffEffectCharmed charmBuff = new BuffEffectCharmed(duration, 2);
                    charmBuff.setCharmer(caster);
                    ((EntityCreature)target).func_70690_d((PotionEffect)charmBuff);
                }
                return true;
            }
        } else {
            if (caster instanceof EntityPlayer) {
                ((EntityPlayer)caster).func_145747_a((IChatComponent)new ChatComponentText("You cannot have any more summons."));
            }
            return true;
        }
        return false;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 300.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return 300.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 10; ++i) {
            AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "heart", x, y, z));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 2.0, 1.0);
            particle.AddParticleController(new ParticleFloatUpward(particle, 0.0f, 0.05f + rand.nextFloat() * 0.1f, 1, false));
            particle.setMaxAge(20);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.LIFE);
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.1f;
    }

    @Override
    public MultiblockStructureDefinition getRitualShape() {
        return RitualShapeHelper.instance.hourglass;
    }

    @Override
    public ItemStack[] getReagents() {
        return new ItemStack[]{new ItemStack(Items.field_151015_O), new ItemStack(Items.field_151014_N), new ItemStack(Items.field_151172_bF)};
    }

    @Override
    public int getReagentSearchRadius() {
        return 3;
    }
}

