/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.RitualShapeHelper;
import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.power.IPowerNode;
import am2.api.spell.component.interfaces.IRitualInteraction;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.SpellModifiers;
import am2.blocks.BlocksCommonProxy;
import am2.damage.DamageSources;
import am2.entities.EntityDarkling;
import am2.entities.EntityFireElemental;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.power.PowerNodeRegistry;
import am2.spell.SpellHelper;
import am2.spell.SpellUtils;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class FireDamage
implements ISpellComponent,
IRitualInteraction {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        ItemStack[] reagents;
        Block block = world.func_147439_a(blockx, blocky, blockz);
        if (block == BlocksCommonProxy.obelisk && (reagents = RitualShapeHelper.instance.checkForRitual(this, world, blockx, blocky, blockz)) != null) {
            if (!world.field_72995_K) {
                RitualShapeHelper.instance.consumeRitualReagents(this, world, blockx, blocky, blockz);
                RitualShapeHelper.instance.consumeRitualShape(this, world, blockx, blocky, blockz);
                world.func_147449_b(blockx, blocky, blockz, BlocksCommonProxy.blackAurem);
                PowerNodeRegistry.For(world).registerPowerNode((IPowerNode)world.func_147438_o(blockx, blocky, blockz));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (!(target instanceof EntityLivingBase)) {
            return false;
        }
        float baseDamage = 6.0f;
        double damage = SpellUtils.instance.getModifiedDouble_Add(baseDamage, stack, caster, target, world, 0, SpellModifiers.DAMAGE);
        if (this.isNetherMob(target)) {
            return true;
        }
        return SpellHelper.instance.attackTargetSpecial(stack, target, (DamageSource)DamageSources.causeEntityFireDamage(caster), SpellUtils.instance.modifyDamage(caster, (float)damage));
    }

    private boolean isNetherMob(Entity target) {
        return target instanceof EntityPigZombie || target instanceof EntityDarkling || target instanceof EntityFireElemental || target instanceof EntityGhast;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 120.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return 20.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 5; ++i) {
            AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "explosion_2", x, y, z));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 0.5, 1.0);
            particle.func_70024_g(rand.nextDouble() * 0.2 - 0.1, rand.nextDouble() * 0.2, rand.nextDouble() * 0.2 - 0.1);
            particle.setAffectedByGravity();
            particle.setDontRequireControllers();
            particle.setMaxAge(5);
            particle.setParticleScale(0.1f);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.FIRE);
    }

    @Override
    public int getID() {
        return 15;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[3];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 14);
        objectArray[1] = Items.field_151033_d;
        objectArray[2] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 0);
        return objectArray;
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.01f;
    }

    @Override
    public MultiblockStructureDefinition getRitualShape() {
        return RitualShapeHelper.instance.corruption;
    }

    @Override
    public ItemStack[] getReagents() {
        ItemStack[] itemStackArray = new ItemStack[2];
        itemStackArray[0] = new ItemStack((Item)ItemsCommonProxy.mobFocus);
        itemStackArray[1] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 6);
        return itemStackArray;
    }

    @Override
    public int getReagentSearchRadius() {
        return 3;
    }
}

