/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.api.ArsMagicaApi;
import am2.api.math.AMVector3;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.SpellModifiers;
import am2.items.ItemsCommonProxy;
import am2.spell.SpellUtils;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;

public class RandomTeleport
implements ISpellComponent {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return false;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        AMVector3 rLoc = this.getRandomTeleportLocation(world, stack, caster, target);
        return this.teleportTo(rLoc.x, rLoc.y, rLoc.z, target);
    }

    private AMVector3 getRandomTeleportLocation(World world, ItemStack stack, EntityLivingBase caster, Entity target) {
        AMVector3 origin = new AMVector3(target);
        float maxDist = 9.0f;
        maxDist = (float)SpellUtils.instance.getModifiedDouble_Mul(maxDist, stack, caster, target, world, 0, SpellModifiers.RANGE);
        origin.add(new AMVector3((world.field_73012_v.nextDouble() - 0.5) * (double)maxDist, (world.field_73012_v.nextDouble() - 0.5) * (double)maxDist, (world.field_73012_v.nextDouble() - 0.5) * (double)maxDist));
        return origin;
    }

    protected boolean teleportTo(double par1, double par3, double par5, Entity target) {
        int k;
        int j;
        if (target instanceof EntityLivingBase) {
            EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)target, par1, par3, par5, 0.0f);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return false;
            }
            par1 = event.targetX;
            par3 = event.targetY;
            par5 = event.targetZ;
        }
        double d3 = target.field_70165_t;
        double d4 = target.field_70163_u;
        double d5 = target.field_70161_v;
        target.field_70165_t = par1;
        target.field_70163_u = par3;
        target.field_70161_v = par5;
        boolean locationValid = false;
        int i = MathHelper.func_76128_c((double)target.field_70165_t);
        if (target.field_70170_p.func_72899_e(i, j = MathHelper.func_76128_c((double)target.field_70163_u), k = MathHelper.func_76128_c((double)target.field_70161_v))) {
            boolean targetBlockIsSolid = false;
            while (!targetBlockIsSolid && j > 0) {
                Block l = target.field_70170_p.func_147439_a(i, j - 1, k);
                if (l != Blocks.field_150350_a && l.func_149688_o().func_76230_c()) {
                    targetBlockIsSolid = true;
                    continue;
                }
                target.field_70163_u -= 1.0;
                --j;
            }
            if (targetBlockIsSolid) {
                target.func_70107_b(target.field_70165_t, target.field_70163_u, target.field_70161_v);
                if (target.field_70170_p.func_72945_a(target, target.field_70121_D).isEmpty()) {
                    locationValid = true;
                }
            }
        }
        if (!locationValid) {
            target.func_70107_b(d3, d4, d5);
            return false;
        }
        return true;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 52.5f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return ArsMagicaApi.getBurnoutFromMana(this.manaCost(caster));
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        world.func_72869_a("portal", target.field_70165_t + (rand.nextDouble() - 0.5) * (double)target.field_70130_N, target.field_70163_u + rand.nextDouble() * (double)target.field_70131_O - 0.25, target.field_70161_v + (rand.nextDouble() - 0.5) * (double)target.field_70130_N, (rand.nextDouble() - 0.5) * 2.0, -rand.nextDouble(), (rand.nextDouble() - 0.5) * 2.0);
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.ENDER);
    }

    @Override
    public int getID() {
        return 43;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[2];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 0);
        objectArray[1] = Items.field_151079_bi;
        return objectArray;
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.01f;
    }
}

