/*
 * Decompiled with CFR 0.152.
 */
package am2.utility;

import am2.api.math.AMVector3;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class MathUtilities {
    public static AMVector3 bezier(AMVector3 s, AMVector3 c1, AMVector3 c2, AMVector3 e, float t) {
        if (t < 0.0f || t > 1.0f) {
            throw new InvalidParameterException("t is out of range, with a value of :" + t);
        }
        float one_minus_t = 1.0f - t;
        AMVector3 retValue = new AMVector3(0.0, 0.0, 0.0);
        AMVector3[] terms = new AMVector3[]{MathUtilities.calcNewVector(one_minus_t * one_minus_t * one_minus_t, s), MathUtilities.calcNewVector(3.0f * one_minus_t * one_minus_t * t, c1), MathUtilities.calcNewVector(3.0f * one_minus_t * t * t, c2), MathUtilities.calcNewVector(t * t * t, e)};
        for (int i = 0; i < 4; ++i) {
            retValue.add(terms[i]);
        }
        return retValue;
    }

    private static AMVector3 calcNewVector(float scaler, AMVector3 base) {
        AMVector3 retValue = new AMVector3(base.x, base.y, base.z);
        retValue.scale(scaler);
        return retValue;
    }

    public static AMVector3[] GetHorizontalBlocksInFrontOfCharacter(EntityLivingBase entity, int numBlocks, int x, int y, int z) {
        float speed = 0.1f;
        float factor = (float)Math.PI / 180;
        float sinYawRadians = MathHelper.func_76126_a((float)(entity.field_70177_z * factor));
        float cosYawRadians = MathHelper.func_76134_b((float)(entity.field_70177_z * factor));
        float cosPitchRadians = MathHelper.func_76134_b((float)(entity.field_70125_A * factor));
        double motionZ = cosYawRadians * speed;
        double motionX = -sinYawRadians * speed;
        double curX = x;
        double curY = y;
        double curZ = z;
        float minimum = 0.01f;
        if (Math.abs(motionX) < (double)minimum) {
            motionX = 0.0;
        }
        if (Math.abs(motionZ) < (double)minimum) {
            motionZ = 0.0;
        }
        int lastX = x;
        int lastY = y;
        int lastZ = z;
        AMVector3[] list = new AMVector3[numBlocks];
        list[0] = new AMVector3(x, y, z);
        int count = 1;
        while (count < numBlocks) {
            if ((int)Math.round(curX += motionX) == lastX && (int)Math.round(curY) == lastY && (int)Math.round(curZ += motionZ) == lastZ) continue;
            lastX = (int)Math.round(curX);
            lastY = (int)Math.round(curY);
            lastZ = (int)Math.round(curZ);
            list[count++] = new AMVector3(lastX, lastY, lastZ);
        }
        return list;
    }

    public static AMVector3[] GetBlocksInFrontOfCharacter(EntityLivingBase entity, int numBlocks, int x, int y, int z) {
        float speed = 0.1f;
        float factor = (float)Math.PI / 180;
        float sinYawRadians = MathHelper.func_76126_a((float)(entity.field_70177_z * factor));
        float cosYawRadians = MathHelper.func_76134_b((float)(entity.field_70177_z * factor));
        float sinPitchRadians = MathHelper.func_76126_a((float)(entity.field_70125_A * factor));
        float cosPitchRadians = MathHelper.func_76134_b((float)(entity.field_70125_A * factor));
        double motionZ = cosYawRadians * cosPitchRadians * speed;
        double motionX = -sinYawRadians * cosPitchRadians * speed;
        double motionY = -sinPitchRadians * speed;
        double curX = x;
        double curY = y;
        double curZ = z;
        float minimum = 0.01f;
        if (Math.abs(motionX) < (double)minimum) {
            motionX = 0.0;
        }
        if (Math.abs(motionY) < (double)minimum) {
            motionY = 0.0;
        }
        if (Math.abs(motionZ) < (double)minimum) {
            motionZ = 0.0;
        }
        int lastX = x;
        int lastY = y;
        int lastZ = z;
        AMVector3[] list = new AMVector3[numBlocks];
        list[0] = new AMVector3(x, y, z);
        int count = 1;
        while (count < numBlocks) {
            if ((int)Math.round(curX += motionX) == lastX && (int)Math.round(curY += motionY) == lastY && (int)Math.round(curZ += motionZ) == lastZ) continue;
            lastX = (int)Math.round(curX);
            lastY = (int)Math.round(curY);
            lastZ = (int)Math.round(curZ);
            list[count++] = new AMVector3(lastX, lastY, lastZ);
        }
        return list;
    }

    public static Entity[] GetEntitiesInAngleNearEntity(World world, EntityLivingBase source, int degrees, int radius, Class filterClass, boolean includeSource) {
        if (degrees > 360) {
            degrees = 360;
        }
        if (degrees < 5) {
            return new Entity[0];
        }
        List distanceFilter = world.func_72872_a(filterClass, AxisAlignedBB.func_72330_a((double)((float)source.field_70165_t - (float)radius), (double)(source.field_70163_u - (double)radius), (double)((float)source.field_70161_v - (float)radius), (double)(source.field_70165_t + (double)radius), (double)(source.field_70163_u + (double)radius), (double)(source.field_70161_v + (double)radius)));
        if (!includeSource) {
            for (int x = 0; x < distanceFilter.size(); ++x) {
                if (distanceFilter.get(x) != source) continue;
                distanceFilter.remove(x);
                --x;
            }
        }
        ArrayList<Entity> angleFilter = new ArrayList<Entity>();
        double playerAngle = MathUtilities.NormalizeRotation(source.field_70177_z);
        float maxAngle = degrees;
        for (int i = 0; i < distanceFilter.size(); ++i) {
            Entity curEntity = (Entity)distanceFilter.get(i);
            if (!MathUtilities.isInFieldOfVision(curEntity, source, maxAngle, maxAngle) || !source.func_70685_l(curEntity)) continue;
            angleFilter.add(curEntity);
        }
        Entity[] array = new Entity[angleFilter.size()];
        for (int t = 0; t < angleFilter.size(); ++t) {
            array[t] = (Entity)angleFilter.get(t);
        }
        return array;
    }

    public static boolean isInFieldOfVision(Entity e1, EntityLivingBase e2, float angleX, float angleY) {
        boolean flag2;
        float rotationYawPrime = e2.field_70177_z;
        float rotationPitchPrime = e2.field_70125_A;
        if (e2 instanceof EntityLiving) {
            ((EntityLiving)e2).func_70625_a(e1, 360.0f, 360.0f);
        }
        float f = e2.field_70177_z;
        float f2 = e2.field_70125_A;
        e2.field_70177_z = rotationYawPrime;
        e2.field_70125_A = rotationPitchPrime;
        rotationYawPrime = f;
        rotationPitchPrime = f2;
        float X = angleX;
        float Y = angleY;
        float yawFOVMin = e2.field_70177_z - X;
        float yawFOVMax = e2.field_70177_z + X;
        float pitchFOVMin = e2.field_70125_A - Y;
        float pitchFOVMax = e2.field_70125_A + Y;
        boolean flag1 = yawFOVMin < 0.0f && (rotationYawPrime >= yawFOVMin + 360.0f || rotationYawPrime <= yawFOVMax) || yawFOVMax >= 360.0f && (rotationYawPrime <= yawFOVMax - 360.0f || rotationYawPrime >= yawFOVMin) || yawFOVMax < 360.0f && yawFOVMin >= 0.0f && rotationYawPrime <= yawFOVMax && rotationYawPrime >= yawFOVMin;
        boolean bl = flag2 = pitchFOVMin <= -180.0f && (rotationPitchPrime >= pitchFOVMin + 360.0f || rotationPitchPrime <= pitchFOVMax) || pitchFOVMax > 180.0f && (rotationPitchPrime <= pitchFOVMax - 360.0f || rotationPitchPrime >= pitchFOVMin) || pitchFOVMax < 180.0f && pitchFOVMin >= -180.0f && rotationPitchPrime <= pitchFOVMax && rotationPitchPrime >= pitchFOVMin;
        return flag1 && flag2 && e2.func_70685_l(e1);
    }

    public static double NormalizeRotation(double yawValue) {
        block3: {
            block2: {
                if (!(yawValue < 0.0)) break block2;
                while (yawValue < 0.0) {
                    yawValue += 360.0;
                }
                break block3;
            }
            if (!(yawValue > 359.0)) break block3;
            while (yawValue > 359.0) {
                yawValue -= 360.0;
            }
        }
        return yawValue;
    }

    public static AMVector3 GetMovementVectorBetweenEntities(Entity from, Entity to) {
        AMVector3 fromPosition = new AMVector3(from.field_70165_t, from.field_70163_u, from.field_70161_v);
        AMVector3 toPosition = new AMVector3(to.field_70165_t, to.field_70163_u, to.field_70161_v);
        AMVector3 delta = fromPosition.sub(toPosition);
        delta.normalize();
        return delta;
    }

    public static AMVector3 GetMovementVectorBetweenPoints(AMVector3 from, AMVector3 to) {
        AMVector3 delta = from.sub(to);
        delta.normalize();
        return delta;
    }

    public static Entity getPointedEntity(World world, EntityLivingBase entityplayer, double range, double collideRadius) {
        return MathUtilities.getPointedEntity(world, entityplayer, range, collideRadius, false);
    }

    public static Entity getPointedEntity(World world, EntityLivingBase entityplayer, double range, double collideRadius, boolean nonCollide) {
        Entity pointedEntity = null;
        double d = range;
        Vec3 vec3d = Vec3.func_72443_a((double)entityplayer.field_70165_t, (double)(entityplayer.field_70163_u + (double)entityplayer.func_70047_e()), (double)entityplayer.field_70161_v);
        Vec3 vec3d1 = entityplayer.func_70040_Z();
        Vec3 vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * d, vec3d1.field_72448_b * d, vec3d1.field_72449_c * d);
        double f1 = collideRadius;
        List list = world.func_72839_b((Entity)entityplayer, entityplayer.field_70121_D.func_72321_a(vec3d1.field_72450_a * d, vec3d1.field_72448_b * d, vec3d1.field_72449_c * d).func_72314_b(f1, f1, f1));
        double d2 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d3;
            Entity entity = (Entity)list.get(i);
            MovingObjectPosition mop = world.func_72901_a(Vec3.func_72443_a((double)entityplayer.field_70165_t, (double)(entityplayer.field_70163_u + (double)entityplayer.func_70047_e()), (double)entityplayer.field_70161_v), Vec3.func_72443_a((double)entity.field_70165_t, (double)(entity.field_70163_u + (double)entity.func_70047_e()), (double)entity.field_70161_v), false);
            if (!entity.func_70067_L() && !nonCollide || mop != null) continue;
            float f2 = Math.max(0.8f, entity.func_70111_Y());
            AxisAlignedBB axisalignedbb = entity.field_70121_D.func_72314_b((double)f2, (double)f2, (double)f2);
            MovingObjectPosition movingobjectposition = axisalignedbb.func_72327_a(vec3d, vec3d2);
            if (axisalignedbb.func_72318_a(vec3d)) {
                if (!(0.0 < d2) && d2 != 0.0) continue;
                pointedEntity = entity;
                d2 = 0.0;
                continue;
            }
            if (movingobjectposition == null || !((d3 = vec3d.func_72438_d(movingobjectposition.field_72307_f)) < d2) && d2 != 0.0) continue;
            pointedEntity = entity;
            d2 = d3;
        }
        return pointedEntity;
    }

    public static Vec3 extrapolateEntityLook(World par1World, EntityLivingBase entity, double range) {
        float var4 = 1.0f;
        float var5 = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * var4;
        float var6 = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * var4;
        double var7 = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)var4;
        double var9 = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)var4 + 1.6 - (double)entity.field_70129_M;
        double var11 = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)var4;
        Vec3 var13 = Vec3.func_72443_a((double)var7, (double)var9, (double)var11);
        float var14 = MathHelper.func_76134_b((float)(-var6 * ((float)Math.PI / 180) - (float)Math.PI));
        float var15 = MathHelper.func_76126_a((float)(-var6 * ((float)Math.PI / 180) - (float)Math.PI));
        float var16 = -MathHelper.func_76134_b((float)(-var5 * ((float)Math.PI / 180)));
        float var17 = MathHelper.func_76126_a((float)(-var5 * ((float)Math.PI / 180)));
        float var18 = var15 * var16;
        float var20 = var14 * var16;
        double var21 = range;
        Vec3 var23 = var13.func_72441_c((double)var18 * var21, (double)var17 * var21, (double)var20 * var21);
        return var23;
    }

    public static AMVector3 getLook(Entity source, float f) {
        if (f == 1.0f) {
            float var2 = MathHelper.func_76134_b((float)(-source.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
            float var3 = MathHelper.func_76126_a((float)(-source.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
            float var4 = -MathHelper.func_76134_b((float)(-source.field_70125_A * ((float)Math.PI / 180)));
            float var5 = MathHelper.func_76126_a((float)(-source.field_70125_A * ((float)Math.PI / 180)));
            return new AMVector3(var3 * var4, var5, var2 * var4);
        }
        float var2 = source.field_70127_C + (source.field_70125_A - source.field_70127_C) * f;
        float var3 = source.field_70126_B + (source.field_70177_z - source.field_70126_B) * f;
        float var4 = MathHelper.func_76134_b((float)(-var3 * ((float)Math.PI / 180) - (float)Math.PI));
        float var5 = MathHelper.func_76126_a((float)(-var3 * ((float)Math.PI / 180) - (float)Math.PI));
        float var6 = -MathHelper.func_76134_b((float)(-var2 * ((float)Math.PI / 180)));
        float var7 = MathHelper.func_76126_a((float)(-var2 * ((float)Math.PI / 180)));
        return new AMVector3(var5 * var6, var7, var4 * var6);
    }

    public static int getDistanceToGround(EntityLivingBase ent, World world) {
        int yCoord = (int)ent.field_70163_u;
        int distance = 0;
        while (!(distance >= 20 || world.func_147437_c((int)Math.floor(ent.field_70165_t), yCoord, (int)Math.floor(ent.field_70161_v)) || world.func_147437_c((int)Math.ceil(ent.field_70165_t), yCoord, (int)Math.floor(ent.field_70161_v)) || world.func_147437_c((int)Math.floor(ent.field_70165_t), yCoord, (int)Math.ceil(ent.field_70161_v)) || world.func_147437_c((int)Math.ceil(ent.field_70165_t), yCoord, (int)Math.ceil(ent.field_70161_v)))) {
            ++distance;
            --yCoord;
        }
        return distance;
    }

    public static float[] colorIntToFloats(int color) {
        float[] colors = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        return colors;
    }

    public static int colorFloatsToInt(float r, float g, float b) {
        return ((int)(r * 255.0f) << 16) + ((int)(g * 255.0f) << 8) + (int)(b * 255.0f);
    }

    public static int[] push(int[] original, int value) {
        int[] newArr = new int[original.length + 1];
        for (int i = 0; i < original.length; ++i) {
            newArr[i] = original[i];
        }
        newArr[newArr.length - 1] = value;
        return newArr;
    }

    public static int[] splice(int[] arr, int index) {
        if (arr.length <= 1) {
            return arr;
        }
        int[] newArr = new int[arr.length - 1];
        int count = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (i == index) continue;
            newArr[count++] = arr[i];
        }
        return newArr;
    }
}

