/*
 * Decompiled with CFR 0.152.
 */
package com.hancinworld.fw.proxy;

import com.hancinworld.fw.handler.ConfigurationHandler;
import com.hancinworld.fw.handler.DrawScreenEventHandler;
import com.hancinworld.fw.handler.KeyInputEventHandler;
import com.hancinworld.fw.proxy.CommonProxy;
import com.hancinworld.fw.utility.LogHelper;
import cpw.mods.fml.client.SplashProgress;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;

public class ClientProxy
extends CommonProxy {
    private Rectangle _savedWindowedBounds;
    public static boolean currentState;
    public static KeyBinding fullscreenKeyBinding;
    public DrawScreenEventHandler dsHandler;
    private boolean _startupRequestedSetting;
    public static KeyBinding ignoreKeyBinding;

    public ClientProxy() {
        Minecraft mc = Minecraft.func_71410_x();
        this._startupRequestedSetting = mc.field_71474_y.field_74353_u;
        mc.field_71474_y.field_74353_u = false;
    }

    @Override
    public void registerKeyBindings() {
        if (fullscreenKeyBinding == null && ConfigurationHandler.instance().isFullscreenWindowedEnabled()) {
            Minecraft mc = Minecraft.func_71410_x();
            fullscreenKeyBinding = mc.field_71474_y.field_152395_am;
            mc.field_71474_y.field_152395_am = ignoreKeyBinding;
            if (Display.isFullscreen()) {
                this.toggleFullScreen(true, 0);
            }
        } else if (fullscreenKeyBinding != null && !ConfigurationHandler.instance().isFullscreenWindowedEnabled()) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.field_71474_y.field_152395_am = fullscreenKeyBinding;
            fullscreenKeyBinding = null;
            if (currentState) {
                mc.func_71352_k();
            }
        }
    }

    @Override
    public void subscribeEvents(File configurationFile) {
        ConfigurationHandler.instance().init(configurationFile);
        FMLCommonHandler.instance().bus().register((Object)ConfigurationHandler.instance());
        FMLCommonHandler.instance().bus().register((Object)new KeyInputEventHandler());
        this.dsHandler = new DrawScreenEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)this.dsHandler);
    }

    private Rectangle findCurrentScreenDimensionsAndPosition(int x, int y) {
        GraphicsDevice[] screens;
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice dev : screens = env.getScreenDevices()) {
            GraphicsConfiguration displayMode = dev.getDefaultConfiguration();
            Rectangle bounds = displayMode.getBounds();
            if (!bounds.contains(x, y)) continue;
            return bounds;
        }
        return new Rectangle(0, 0, Display.getDesktopDisplayMode().getWidth(), Display.getDesktopDisplayMode().getHeight());
    }

    private Rectangle findScreenDimensionsByID(int monitorID) {
        if (monitorID < 1) {
            return null;
        }
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screens = env.getScreenDevices();
        if (screens == null || screens.length == 0 || screens.length < monitorID) {
            return null;
        }
        return screens[monitorID - 1].getDefaultConfiguration().getBounds();
    }

    private void callMinecraftResizeMethod(int w, int h) {
        try {
            Class[] args = new Class[]{Integer.TYPE, Integer.TYPE};
            Minecraft inst = Minecraft.func_71410_x();
            Method resizeMethod = ReflectionHelper.findMethod(Minecraft.class, (Object)inst, (String[])new String[]{"func_71370_a", "resize"}, (Class[])args);
            if (resizeMethod != null) {
                Display.update();
                resizeMethod.invoke((Object)inst, w, h);
            }
        }
        catch (Exception e) {
            LogHelper.warn("Resize method not found or problem found while calling it. Are you using the correct version of the mod for this version of Minecraft?" + e.toString());
        }
    }

    private Rectangle getAppropriateScreenBounds(Rectangle currentCoordinates, int desiredMonitor) {
        Rectangle screenBounds;
        Point centerCoordinates = new Point((int)(currentCoordinates.getMinX() + currentCoordinates.getWidth() / 2.0), (int)(currentCoordinates.getMinY() + currentCoordinates.getHeight() / 2.0));
        ConfigurationHandler configuration = ConfigurationHandler.instance();
        if (configuration.areAdvancedFeaturesEnabled() && configuration.isOnlyRemoveDecorations()) {
            screenBounds = currentCoordinates;
        } else if (configuration.areAdvancedFeaturesEnabled() && configuration.isCustomFullscreenDimensions() && configuration.getCustomFullscreenDimensionsH() > 256 && configuration.getCustomFullscreenDimensionsW() > 256) {
            Rectangle actualScreenBounds;
            screenBounds = new Rectangle(configuration.getCustomFullscreenDimensionsX(), configuration.getCustomFullscreenDimensionsY(), configuration.getCustomFullscreenDimensionsW(), configuration.getCustomFullscreenDimensionsH());
            if (desiredMonitor > 0 && (actualScreenBounds = this.findScreenDimensionsByID(desiredMonitor)) != null) {
                screenBounds.setLocation(actualScreenBounds.x + screenBounds.x, actualScreenBounds.y + screenBounds.y);
            }
        } else if (desiredMonitor < 0 || desiredMonitor == 0) {
            screenBounds = this.findCurrentScreenDimensionsAndPosition((int)centerCoordinates.getX(), (int)centerCoordinates.getY());
        } else {
            screenBounds = this.findScreenDimensionsByID(desiredMonitor);
            if (screenBounds == null) {
                screenBounds = this.findCurrentScreenDimensionsAndPosition((int)centerCoordinates.getX(), (int)centerCoordinates.getY());
            }
        }
        return screenBounds;
    }

    @Override
    public void toggleFullScreen(boolean goFullScreen, int desiredMonitor) {
        Rectangle newBounds;
        if (Display.isFullscreen()) {
            currentState = true;
            LogHelper.warn("Display is actual fullscreen! Is Minecraft starting with the option set?");
        }
        if (currentState == goFullScreen && !Display.isFullscreen()) {
            return;
        }
        Rectangle currentCoordinates = new Rectangle(Display.getX(), Display.getY(), Display.getWidth(), Display.getHeight());
        if (goFullScreen) {
            this._savedWindowedBounds = currentCoordinates;
        }
        System.setProperty("org.lwjgl.opengl.Window.undecorated", goFullScreen ? "true" : "false");
        Rectangle screenBounds = this.getAppropriateScreenBounds(currentCoordinates, desiredMonitor);
        Rectangle rectangle = newBounds = goFullScreen ? screenBounds : this._savedWindowedBounds;
        if (newBounds == null) {
            newBounds = screenBounds;
        }
        try {
            Display.setDisplayMode((DisplayMode)new DisplayMode((int)newBounds.getWidth(), (int)newBounds.getHeight()));
            Display.setResizable((!goFullScreen ? 1 : 0) != 0);
            Display.setFullscreen((boolean)false);
            Display.update();
            Display.setLocation((int)newBounds.x, (int)newBounds.y);
            this.callMinecraftResizeMethod((int)newBounds.getWidth(), (int)newBounds.getHeight());
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
        currentState = goFullScreen;
    }

    @Override
    public void performStartupChecks() {
        if (!ConfigurationHandler.instance().isFullscreenWindowedEnabled()) {
            Minecraft.func_71410_x().field_71474_y.field_74353_u = this._startupRequestedSetting;
            return;
        }
        if (ConfigurationHandler.instance().isMaximumCompatibilityEnabled()) {
            this.dsHandler.setInitialFullscreen(this._startupRequestedSetting, ConfigurationHandler.instance().getFullscreenMonitor());
        } else {
            try {
                SplashProgress.pause();
                this.toggleFullScreen(this._startupRequestedSetting, ConfigurationHandler.instance().getFullscreenMonitor());
                SplashProgress.resume();
            }
            catch (NoClassDefFoundError e) {
                LogHelper.warn("Error while doing startup checks, are you using an old version of Forge ? " + e);
                this.toggleFullScreen(this._startupRequestedSetting, ConfigurationHandler.instance().getFullscreenMonitor());
            }
        }
    }

    static {
        ignoreKeyBinding = new KeyBinding("key.fullscreenwindowed.unused", 0, "key.categories.misc");
    }
}

