/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks;

import am2.AMCore;
import am2.blocks.AMBlock;
import am2.buffs.BuffList;
import am2.entities.EntityBroom;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleFloatUpward;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockInvisibleUtility
extends AMBlock {
    public BlockInvisibleUtility() {
        super(Material.field_151592_s);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 0.01f, 0.01f, 0.01f);
        this.func_149675_a(true);
    }

    public int func_149738_a(World par1World) {
        return 5;
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        int meta = par1World.func_72805_g(par2, par3, par4);
        if (meta == 0 || meta == 1 || meta == 2) {
            return null;
        }
        return AxisAlignedBB.func_72330_a((double)par2, (double)par3, (double)par4, (double)(par2 + 1), (double)(par3 + 1), (double)(par4 + 1)).func_72314_b(1.0, 1.0, 1.0);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB axisAlignedBB, List collisionList, Entity entity) {
        if (entity == null || world == null || entity instanceof EntityPlayer || entity instanceof EntityBroom) {
            return;
        }
        int meta = world.func_72805_g(x, y, z);
        double distanceThreshold = 1.1;
        double shortDistanceThreshold = 0.1;
        boolean isCollided = false;
        if ((double)entity.field_70130_N < 0.5 || (double)entity.field_70131_O < 0.5) {
            distanceThreshold = 0.5;
            shortDistanceThreshold = -0.2f;
        }
        if (meta > 2 && meta < 10) {
            switch (meta) {
                case 3: {
                    if (!(entity.field_70165_t > (double)x + distanceThreshold)) break;
                    collisionList.add(AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)((double)x + 1.25), (double)((double)y + 1.6), (double)((double)z + 1.25)));
                    isCollided = true;
                    break;
                }
                case 4: {
                    if (!(entity.field_70165_t < (double)x - shortDistanceThreshold)) break;
                    collisionList.add(AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)((double)x + 1.25), (double)((double)y + 1.6), (double)((double)z + 1.25)));
                    isCollided = true;
                    break;
                }
                case 5: {
                    if (!(entity.field_70161_v > (double)z + distanceThreshold)) break;
                    collisionList.add(AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)((double)x + 1.25), (double)((double)y + 1.6), (double)((double)z + 1.25)));
                    isCollided = true;
                    break;
                }
                case 6: {
                    if (!(entity.field_70161_v < (double)z - shortDistanceThreshold)) break;
                    collisionList.add(AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)((double)x + 1.25), (double)((double)y + 1.6), (double)((double)z + 1.25)));
                    isCollided = true;
                    break;
                }
                case 7: {
                    if (!(entity.field_70165_t > (double)x + distanceThreshold) && !(entity.field_70165_t < (double)x - shortDistanceThreshold)) break;
                    collisionList.add(AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)((double)x + 1.25), (double)((double)y + 1.6), (double)((double)z + 1.25)));
                    isCollided = true;
                    break;
                }
                case 8: {
                    if (!(entity.field_70161_v > (double)z + distanceThreshold) && !(entity.field_70161_v < (double)z - shortDistanceThreshold)) break;
                    collisionList.add(AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)((double)x + 1.25), (double)((double)y + 1.6), (double)((double)z + 1.25)));
                    isCollided = true;
                    break;
                }
                case 9: {
                    collisionList.add(AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)((double)x + 1.25), (double)((double)y + 1.6), (double)((double)z + 1.25)));
                    isCollided = true;
                }
            }
            if (world.field_72995_K && isCollided) {
                this.spawnBlockParticles(world, x, y, z);
            }
        }
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        int meta;
        if (world.field_72995_K && (meta = world.func_72805_g(x, y, z)) > 2 && meta < 10) {
            this.spawnBlockParticles(world, x, y, z);
        }
    }

    private void spawnBlockParticles(World world, int x, int y, int z) {
        AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "symbols", (double)x + 0.5, (double)y + 0.5, (double)z + 0.5));
        if (particle != null) {
            particle.addRandomOffset(1.0, 1.6, 1.0);
            particle.setParticleScale(0.1f);
            particle.AddParticleController(new ParticleFloatUpward(particle, 0.0f, 0.02f, 1, false));
            particle.AddParticleController(new ParticleFadeOut(particle, 1, false).setFadeSpeed(0.05f));
            particle.setMaxAge(20);
            if (world.field_73012_v.nextBoolean()) {
                particle.setRGBColorI(4725704);
            } else {
                particle.setRGBColorI(8985544);
            }
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return null;
    }

    public boolean func_149659_a(Explosion par1Explosion) {
        return false;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return false;
    }

    public boolean isAir(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public boolean canRenderInPass(int pass) {
        return false;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        switch (meta) {
            case 0: {
                return 8;
            }
            case 1: {
                return 12;
            }
            case 2: 
            case 10: {
                return 15;
            }
        }
        return 0;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return true;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        int meta = world.func_72805_g(x, y, z);
        if (meta < 3) {
            float r = 1.5f;
            List ents = world.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)((float)x - r), (double)((float)y - r), (double)((float)z - r), (double)((float)(x + 1) + r), (double)((float)(y + 1) + r), (double)((float)(z + 1) + r)));
            boolean buffNearby = false;
            for (EntityLivingBase ent : ents) {
                buffNearby |= ent.func_82165_m(BuffList.illumination.field_76415_H) || ent instanceof EntityPlayer && ((EntityPlayer)ent).field_71071_by.func_70448_g() != null && ((EntityPlayer)ent).field_71071_by.func_70448_g().func_77973_b() == ItemsCommonProxy.wardingCandle;
            }
            if (!buffNearby && world.func_147439_a(x, y, z) == this) {
                world.func_147468_f(x, y, z);
            }
            world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
        }
    }

    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        List ents;
        int meta = world.func_72805_g(x, y, z);
        if (world.field_73012_v.nextInt(10) < 3 && world.field_72995_K && meta >= 3 && meta < 10 && (ents = world.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)((double)x - 0.2), (double)((double)y - 0.2), (double)((double)z - 0.2), (double)((double)x + 1.2), (double)((double)y + 1.2), (double)((double)z + 1.2)))).size() > 0) {
            this.spawnBlockParticles(world, x, y, z);
        }
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        int meta = world.func_72805_g(x, y, z);
        if (meta > 2) {
            return 100.0f;
        }
        return super.getExplosionResistance(par1Entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
    }

    public ArrayList<ItemStack> getDrops(World arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        return new ArrayList<ItemStack>();
    }
}

