/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentities;

import am2.AMCore;
import am2.LogHelper;
import am2.blocks.BlocksCommonProxy;
import am2.particles.AMParticle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.ChunkPosition;

public class TileEntityEverstone
extends TileEntity {
    private int reconstructTimer = 0;
    private Block facade = null;
    private int facadeMeta = -1;
    private static final int reconstructMax = AMCore.config.getEverstoneRepairRate();
    private boolean poweredFromEverstone = false;
    private boolean poweredFromRedstone = false;

    public void setFacade(Block block, int meta) {
        this.facade = block;
        this.facadeMeta = meta;
        if (!this.field_145850_b.field_72995_K) {
            List players = this.field_145850_b.func_72872_a(EntityPlayerMP.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)).func_72314_b(64.0, 64.0, 64.0));
            for (EntityPlayerMP player : players) {
                player.field_71135_a.func_147359_a(this.func_145844_m());
            }
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private void propagatePoweredByEverstone(boolean powered, ArrayList<ChunkPosition> completedUpdates) {
        AMParticle particle;
        ChunkPosition myPosition = new ChunkPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (completedUpdates.contains(myPosition)) {
            return;
        }
        completedUpdates.add(myPosition);
        this.poweredFromEverstone = powered;
        this.onBreak();
        if (this.field_145850_b.field_72995_K && (particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_145850_b, "radiant", (float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 0.5f, (float)this.field_145849_e + 0.5f))) != null) {
            particle.setMaxAge(20);
            particle.setDontRequireControllers();
            particle.setIgnoreMaxAge(false);
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    TileEntityEverstone everstone;
                    ChunkPosition targetPosition = new ChunkPosition(this.field_145851_c + i, this.field_145848_d + j, this.field_145849_e + k);
                    Block blockID = this.field_145850_b.func_147439_a(targetPosition.field_151329_a, targetPosition.field_151327_b, targetPosition.field_151328_c);
                    if (blockID != BlocksCommonProxy.everstone || completedUpdates.contains(targetPosition) || (everstone = (TileEntityEverstone)this.field_145850_b.func_147438_o(targetPosition.field_151329_a, targetPosition.field_151327_b, targetPosition.field_151328_c)) == null) continue;
                    everstone.propagatePoweredByEverstone(powered, completedUpdates);
                }
            }
        }
    }

    public void func_145845_h() {
        if (this.reconstructTimer <= 0 && this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            this.propagatePoweredByEverstone(true, new ArrayList<ChunkPosition>());
            this.poweredFromRedstone = true;
        } else if (this.poweredFromRedstone && !this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            this.poweredFromRedstone = false;
            this.propagatePoweredByEverstone(false, new ArrayList<ChunkPosition>());
        }
        if (this.reconstructTimer <= 0) {
            return;
        }
        if (!this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) && !this.poweredFromEverstone) {
            --this.reconstructTimer;
            if (this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                if (this.reconstructTimer < reconstructMax - 20 && this.reconstructTimer > 20 && this.field_145850_b.field_73012_v.nextInt(10) < 8) {
                    AMCore.proxy.addDigParticle(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)(this.getFacade() == null ? BlocksCommonProxy.everstone : this.getFacade()), this.getFacadeMeta());
                }
            }
        }
    }

    public int getFadeStrength() {
        if (this.reconstructTimer > reconstructMax / 2) {
            return 0;
        }
        return (int)(128.0f * ((float)(reconstructMax - this.reconstructTimer) / (float)reconstructMax));
    }

    public Block getFacade() {
        return this.facade;
    }

    public int getFacadeMeta() {
        return this.facadeMeta;
    }

    public boolean isSolid() {
        return this.reconstructTimer == 0;
    }

    public void onBreak() {
        this.reconstructTimer = reconstructMax;
        if (!this.field_145850_b.field_72995_K) {
            List players = this.field_145850_b.func_72872_a(EntityPlayerMP.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)).func_72314_b(64.0, 64.0, 64.0));
            for (EntityPlayerMP player : players) {
                player.field_71135_a.func_147359_a(this.func_145844_m());
            }
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_145841_b(compound);
        S35PacketUpdateTileEntity packet = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e), compound);
        return packet;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound par1nbtTagCompound) {
        super.func_145839_a(par1nbtTagCompound);
        if (par1nbtTagCompound.func_74764_b("facade")) {
            this.facade = Block.func_149684_b((String)par1nbtTagCompound.func_74779_i("facade"));
            LogHelper.debug("Facade: " + par1nbtTagCompound.func_74779_i("facade"), new Object[0]);
            this.facadeMeta = par1nbtTagCompound.func_74762_e("facadeMeta");
        }
        this.poweredFromEverstone = par1nbtTagCompound.func_74767_n("poweredFromEverstone");
        this.poweredFromRedstone = par1nbtTagCompound.func_74767_n("poweredFromRedstone");
        this.reconstructTimer = par1nbtTagCompound.func_74762_e("reconstructTimer");
    }

    public void func_145841_b(NBTTagCompound par1nbtTagCompound) {
        super.func_145841_b(par1nbtTagCompound);
        if (this.facade != null) {
            par1nbtTagCompound.func_74778_a("facade", this.facade.func_149739_a().replace("tile.", ""));
            par1nbtTagCompound.func_74768_a("facadeMeta", this.facadeMeta);
        }
        par1nbtTagCompound.func_74757_a("poweredFromEverstone", this.poweredFromEverstone);
        par1nbtTagCompound.func_74757_a("poweredFromRedstone", this.poweredFromRedstone);
        par1nbtTagCompound.func_74768_a("reconstructTimer", this.reconstructTimer);
    }
}

