/*
 * Decompiled with CFR 0.152.
 */
package am2.enchantments;

import am2.AMCore;
import am2.LogHelper;
import am2.enchantments.EnchantMagicResist;
import am2.enchantments.EnchantmentSoulbound;
import cpw.mods.fml.common.registry.LanguageRegistry;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;

public class AMEnchantments {
    public static EnchantMagicResist magicResist = (EnchantMagicResist)((Object)AMEnchantments.registerEnchantment(EnchantMagicResist.class, 5, "magic_resist", 100));
    public static EnchantmentSoulbound soulbound = (EnchantmentSoulbound)((Object)AMEnchantments.registerEnchantment(EnchantmentSoulbound.class, 5, "soulbound", 101));

    public void Init() {
        int defMR = AMCore.config.getConfigurableEnchantmentID("magic_resist", 100);
        Enchantment.addToBookList((Enchantment)magicResist);
        Enchantment.addToBookList((Enchantment)soulbound);
        LanguageRegistry.instance().addStringLocalization("enchantment.magicresist", "en_US", "Magic Resistance");
        LanguageRegistry.instance().addStringLocalization("enchantment.soulbound", "en_US", "Soulbound");
    }

    private static <T extends Enchantment> T registerEnchantment(Class<? extends Enchantment> enchantmentClass, int weight, String configID, int default_value) {
        int start_value;
        int enchID = start_value = AMCore.config.getConfigurableEnchantmentID(configID, default_value);
        boolean fullcircle = true;
        do {
            if (Enchantment.field_77331_b[enchID] == null) {
                fullcircle = false;
                break;
            }
            ++enchID;
        } while ((enchID %= Enchantment.field_77331_b.length) != start_value);
        if (fullcircle) {
            throw new ArrayIndexOutOfBoundsException("All enchantment IDs are in use...can't find a free one to take!");
        }
        LogHelper.info("Attempting to set enchantment %s to ID %d (configured currently as %d)", configID, enchID, start_value);
        AMCore.config.updateConfigurableEnchantmentID(configID, enchID);
        try {
            Enchantment ench = enchantmentClass.getConstructor(Integer.TYPE, Integer.TYPE).newInstance(enchID, weight);
            LogHelper.info("Successfully registered enchanment!", new Object[0]);
            return (T)ench;
        }
        catch (Throwable t) {
            LogHelper.error("Failed to register enchantment %s!", configID);
            t.printStackTrace();
            return null;
        }
    }

    public static int GetEnchantmentLevelSpecial(int enchID, ItemStack stack) {
        int baseEnchLvl = EnchantmentHelper.func_77506_a((int)enchID, (ItemStack)stack);
        return baseEnchLvl;
    }
}

