/*
 * Decompiled with CFR 0.152.
 */
package am2.particles;

import am2.particles.AMParticle;
import am2.particles.ParticleController;

public class ParticleExpandingCollapsingRingAtPoint
extends ParticleController {
    private double minDistance;
    private double maxDistance;
    private double speed;
    private CoordStore target;
    private boolean collapseOnce;
    private boolean isCollapsing;
    private boolean hasCollapsed;

    public ParticleExpandingCollapsingRingAtPoint(AMParticle particleEffect, double x, double y, double z, double minDistance, double maxDistance, double speed, int priority, boolean exclusive) {
        super(particleEffect, priority, exclusive);
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
        this.speed = speed;
        this.target = new CoordStore(x, y, z);
    }

    public ParticleExpandingCollapsingRingAtPoint setCollapseOnce() {
        this.collapseOnce = true;
        return this;
    }

    public ParticleExpandingCollapsingRingAtPoint setExpanding() {
        this.isCollapsing = false;
        return this;
    }

    @Override
    public void doUpdate() {
        double deltax = this.target.x - this.particle.field_70165_t;
        double deltaz = this.target.z - this.particle.field_70161_v;
        double angle = Math.atan2(deltaz, deltax);
        double distance = Math.sqrt(deltaz * deltaz + deltax * deltax);
        double factor = 0.0;
        factor = this.isCollapsing ? this.speed : -this.speed;
        double posX = Math.cos(angle) * factor;
        double posZ = Math.sin(angle) * factor;
        if (distance <= this.minDistance) {
            this.isCollapsing = false;
            this.hasCollapsed = true;
        } else if (distance >= this.maxDistance) {
            if (this.collapseOnce && this.hasCollapsed) {
                this.finish();
            } else {
                this.isCollapsing = true;
            }
        }
        this.particle.func_70107_b(this.particle.field_70165_t + posX, this.particle.field_70163_u, this.particle.field_70161_v + posZ);
    }

    @Override
    public ParticleController clone() {
        return new ParticleExpandingCollapsingRingAtPoint(this.particle, this.target.x, this.target.y, this.target.z, this.minDistance, this.maxDistance, this.speed, this.priority, this.collapseOnce);
    }

    private class CoordStore {
        public double x;
        public double y;
        public double z;

        public CoordStore(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

