/*
 * Decompiled with CFR 0.152.
 */
package am2.spell;

import am2.AMCore;
import am2.api.ArsMagicaApi;
import am2.api.events.AffinityChangingEvent;
import am2.api.events.ModifierCalculatedEvent;
import am2.api.spell.ISpellUtils;
import am2.api.spell.component.interfaces.ISkillTreeEntry;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.component.interfaces.ISpellModifier;
import am2.api.spell.component.interfaces.ISpellPart;
import am2.api.spell.component.interfaces.ISpellShape;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.SpellModifiers;
import am2.armor.ArmorHelper;
import am2.armor.ArsMagicaArmorMaterial;
import am2.enchantments.AMEnchantmentHelper;
import am2.items.ItemsCommonProxy;
import am2.playerextensions.AffinityData;
import am2.playerextensions.ExtendedProperties;
import am2.playerextensions.SkillData;
import am2.spell.SkillManager;
import am2.spell.SkillTreeManager;
import am2.spell.SpellStageDefinition;
import am2.spell.components.Summon;
import am2.spell.shapes.MissingShape;
import am2.utility.KeyValuePair;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class SpellUtils
implements ISpellUtils {
    private static final String CurShapeGroup_Identifier = "CurrentShapeGroup";
    private static final String NumShapeGroups_Identifier = "NumShapeGroups";
    private static final String ShapeGroup_Identifier = "ShapeGroup_";
    private static final String ShapeGroupMeta_Identifier = "ShapeGroupMeta_";
    private static final String Stages_Identifier = "NumStages";
    private static final String Shape_Prefix = "ShapeOrdinal_";
    private static final String Component_Prefix = "SpellComponentIDs_";
    private static final String Modifier_Prefix = "SpellModifierIDs_";
    private static final String Shape_Meta_Prefix = "ShapeMeta_";
    private static final String Component_Meta_Prefix = "SpellComponentMeta_";
    private static final String Modifier_Meta_Prefix = "SpellModifierMeta_";
    private static final String Global_Spell_Meta = "spellMetadata";
    private static final String BaseManaCostIdentifier = "BMC_";
    private static final String BaseBurnoutIdentifier = "BB_";
    private static final String BaseReagentsIdentifier = "BRR";
    private static final String ForcedAffinity = "ForcedAffinity";
    public static SpellUtils instance = new SpellUtils();

    private SpellUtils() {
    }

    @Override
    public double getModifiedDouble_Mul(double defaultValue, ItemStack stack, EntityLivingBase caster, Entity target, World world, SpellModifiers check) {
        return this.getModifiedDouble_Mul(defaultValue, stack, caster, target, world, 0, check);
    }

    @Override
    public int getModifiedInt_Mul(int defaultValue, ItemStack stack, EntityLivingBase caster, Entity target, World world, SpellModifiers check) {
        return this.getModifiedInt_Mul(defaultValue, stack, caster, target, world, 0, check);
    }

    @Override
    public double getModifiedDouble_Mul(SpellModifiers check, ItemStack stack, EntityLivingBase caster, Entity target, World world) {
        return this.getModifiedDouble_Mul(check, stack, caster, target, world, 0);
    }

    @Override
    public int getModifiedInt_Mul(SpellModifiers check, ItemStack stack, EntityLivingBase caster, Entity target, World world) {
        return this.getModifiedInt_Mul(check, stack, caster, target, world, 0);
    }

    @Override
    public double getModifiedDouble_Add(double defaultValue, ItemStack stack, EntityLivingBase caster, Entity target, World world, SpellModifiers check) {
        return this.getModifiedDouble_Add(defaultValue, stack, caster, target, world, 0, check);
    }

    @Override
    public int getModifiedInt_Add(int defaultValue, ItemStack stack, EntityLivingBase caster, Entity target, World world, SpellModifiers check) {
        return this.getModifiedInt_Add(defaultValue, stack, caster, target, world, 0, check);
    }

    @Override
    public double getModifiedDouble_Add(SpellModifiers check, ItemStack stack, EntityLivingBase caster, Entity target, World world) {
        return this.getModifiedDouble_Add(check, stack, caster, target, world, 0);
    }

    @Override
    public int getModifiedInt_Add(SpellModifiers check, ItemStack stack, EntityLivingBase caster, Entity target, World world) {
        return this.getModifiedInt_Add(check, stack, caster, target, world, 0);
    }

    @Override
    public boolean modifierIsPresent(SpellModifiers check, ItemStack stack) {
        return this.modifierIsPresent(check, stack, 0);
    }

    @Override
    public int countModifiers(SpellModifiers check, ItemStack stack) {
        return this.countModifiers(check, stack, 0);
    }

    public double getModifiedDouble_Mul(double defaultValue, ItemStack stack, EntityLivingBase caster, Entity target, World world, int stage, SpellModifiers check) {
        int ordinalCount = 0;
        double modifiedValue = defaultValue;
        for (ISpellModifier modifier : this.getModifiersForStage(stack, stage)) {
            if (!modifier.getAspectsModified().contains((Object)check)) continue;
            byte[] meta = this.getModifierMetadataFromStack(stack, modifier, stage, ordinalCount++);
            modifiedValue *= (double)modifier.getModifier(check, caster, target, world, meta);
        }
        if (caster instanceof EntityPlayer && SkillData.For((EntityPlayer)caster).isEntryKnown(SkillTreeManager.instance.getSkillTreeEntry(SkillManager.instance.getSkill("AugmentedCasting")))) {
            modifiedValue *= (double)1.1f;
        }
        ModifierCalculatedEvent event = new ModifierCalculatedEvent(stack, caster, check, defaultValue, modifiedValue, ModifierCalculatedEvent.OperationType.MULTIPLY);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.modifiedValue;
    }

    public int getModifiedInt_Mul(int defaultValue, ItemStack stack, EntityLivingBase caster, Entity target, World world, int stage, SpellModifiers check) {
        int ordinalCount = 0;
        int modifiedValue = defaultValue;
        for (ISpellModifier modifier : this.getModifiersForStage(stack, stage)) {
            if (!modifier.getAspectsModified().contains((Object)check)) continue;
            byte[] meta = this.getModifierMetadataFromStack(stack, modifier, stage, ordinalCount++);
            modifiedValue = (int)((float)modifiedValue * modifier.getModifier(check, caster, target, world, meta));
        }
        if (caster instanceof EntityPlayer && SkillData.For((EntityPlayer)caster).isEntryKnown(SkillTreeManager.instance.getSkillTreeEntry(SkillManager.instance.getSkill("AugmentedCasting")))) {
            modifiedValue = (int)((float)modifiedValue * 1.1f);
        }
        ModifierCalculatedEvent event = new ModifierCalculatedEvent(stack, caster, check, defaultValue, modifiedValue, ModifierCalculatedEvent.OperationType.MULTIPLY);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return (int)event.modifiedValue;
    }

    public double getModifiedDouble_Mul(SpellModifiers check, ItemStack stack, EntityLivingBase caster, Entity target, World world, int stage) {
        int ordinalCount = 0;
        double modifiedValue = check.defaultValue;
        for (ISpellModifier modifier : this.getModifiersForStage(stack, stage)) {
            if (!modifier.getAspectsModified().contains((Object)check)) continue;
            byte[] meta = this.getModifierMetadataFromStack(stack, modifier, stage, ordinalCount++);
            modifiedValue *= (double)modifier.getModifier(check, caster, target, world, meta);
        }
        if (caster instanceof EntityPlayer && SkillData.For((EntityPlayer)caster).isEntryKnown(SkillTreeManager.instance.getSkillTreeEntry(SkillManager.instance.getSkill("AugmentedCasting")))) {
            modifiedValue *= (double)1.1f;
        }
        ModifierCalculatedEvent event = new ModifierCalculatedEvent(stack, caster, check, check.defaultValue, modifiedValue, ModifierCalculatedEvent.OperationType.MULTIPLY);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.modifiedValue;
    }

    public int getModifiedInt_Mul(SpellModifiers check, ItemStack stack, EntityLivingBase caster, Entity target, World world, int stage) {
        int ordinalCount = 0;
        int modifiedValue = check.defaultValueInt;
        for (ISpellModifier modifier : this.getModifiersForStage(stack, stage)) {
            if (!modifier.getAspectsModified().contains((Object)check)) continue;
            byte[] meta = this.getModifierMetadataFromStack(stack, modifier, stage, ordinalCount++);
            modifiedValue = (int)((float)modifiedValue * modifier.getModifier(check, caster, target, world, meta));
        }
        if (caster instanceof EntityPlayer && SkillData.For((EntityPlayer)caster).isEntryKnown(SkillTreeManager.instance.getSkillTreeEntry(SkillManager.instance.getSkill("AugmentedCasting")))) {
            modifiedValue = (int)((float)modifiedValue * 1.1f);
        }
        ModifierCalculatedEvent event = new ModifierCalculatedEvent(stack, caster, check, check.defaultValue, modifiedValue, ModifierCalculatedEvent.OperationType.MULTIPLY);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return (int)event.modifiedValue;
    }

    public double getModifiedDouble_Add(double defaultValue, ItemStack stack, EntityLivingBase caster, Entity target, World world, int stage, SpellModifiers check) {
        int ordinalCount = 0;
        double modifiedValue = defaultValue;
        for (ISpellModifier modifier : this.getModifiersForStage(stack, stage)) {
            if (!modifier.getAspectsModified().contains((Object)check)) continue;
            byte[] meta = this.getModifierMetadataFromStack(stack, modifier, stage, ordinalCount++);
            modifiedValue += (double)modifier.getModifier(check, caster, target, world, meta);
        }
        if (caster instanceof EntityPlayer && SkillData.For((EntityPlayer)caster).isEntryKnown(SkillTreeManager.instance.getSkillTreeEntry(SkillManager.instance.getSkill("AugmentedCasting")))) {
            modifiedValue *= (double)1.1f;
        }
        ModifierCalculatedEvent event = new ModifierCalculatedEvent(stack, caster, check, defaultValue, modifiedValue, ModifierCalculatedEvent.OperationType.ADD);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.modifiedValue;
    }

    public int getModifiedInt_Add(int defaultValue, ItemStack stack, EntityLivingBase caster, Entity target, World world, int stage, SpellModifiers check) {
        int ordinalCount = 0;
        double modifiedValue = defaultValue;
        for (ISpellModifier modifier : this.getModifiersForStage(stack, stage)) {
            if (!modifier.getAspectsModified().contains((Object)check)) continue;
            byte[] meta = this.getModifierMetadataFromStack(stack, modifier, stage, ordinalCount++);
            modifiedValue += (double)modifier.getModifier(check, caster, target, world, meta);
        }
        if (caster instanceof EntityPlayer && SkillData.For((EntityPlayer)caster).isEntryKnown(SkillTreeManager.instance.getSkillTreeEntry(SkillManager.instance.getSkill("AugmentedCasting")))) {
            modifiedValue *= (double)1.1f;
        }
        ModifierCalculatedEvent event = new ModifierCalculatedEvent(stack, caster, check, defaultValue, modifiedValue, ModifierCalculatedEvent.OperationType.ADD);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return (int)Math.ceil(event.modifiedValue);
    }

    public double getModifiedDouble_Add(SpellModifiers check, ItemStack stack, EntityLivingBase caster, Entity target, World world, int stage) {
        int ordinalCount = 0;
        double modifiedValue = check.defaultValue;
        for (ISpellModifier modifier : this.getModifiersForStage(stack, stage)) {
            if (!modifier.getAspectsModified().contains((Object)check)) continue;
            byte[] meta = this.getModifierMetadataFromStack(stack, modifier, stage, ordinalCount++);
            modifiedValue += (double)modifier.getModifier(check, caster, target, world, meta);
        }
        if (caster instanceof EntityPlayer && SkillData.For((EntityPlayer)caster).isEntryKnown(SkillTreeManager.instance.getSkillTreeEntry(SkillManager.instance.getSkill("AugmentedCasting")))) {
            modifiedValue *= (double)1.1f;
        }
        ModifierCalculatedEvent event = new ModifierCalculatedEvent(stack, caster, check, check.defaultValue, modifiedValue, ModifierCalculatedEvent.OperationType.ADD);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.modifiedValue;
    }

    public int getModifiedInt_Add(SpellModifiers check, ItemStack stack, EntityLivingBase caster, Entity target, World world, int stage) {
        int ordinalCount = 0;
        int modifiedValue = check.defaultValueInt;
        for (ISpellModifier modifier : this.getModifiersForStage(stack, stage)) {
            if (!modifier.getAspectsModified().contains((Object)check)) continue;
            byte[] meta = this.getModifierMetadataFromStack(stack, modifier, stage, ordinalCount++);
            modifiedValue = (int)((float)modifiedValue + modifier.getModifier(check, caster, target, world, meta));
        }
        if (caster instanceof EntityPlayer && SkillData.For((EntityPlayer)caster).isEntryKnown(SkillTreeManager.instance.getSkillTreeEntry(SkillManager.instance.getSkill("AugmentedCasting")))) {
            modifiedValue = (int)((float)modifiedValue * 1.1f);
        }
        ModifierCalculatedEvent event = new ModifierCalculatedEvent(stack, caster, check, check.defaultValue, modifiedValue, ModifierCalculatedEvent.OperationType.ADD);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return (int)event.modifiedValue;
    }

    public boolean modifierIsPresent(SpellModifiers check, ItemStack stack, int stage) {
        for (ISpellModifier modifier : this.getModifiersForStage(stack, stage)) {
            if (!modifier.getAspectsModified().contains((Object)check)) continue;
            return true;
        }
        return false;
    }

    public int countModifiers(SpellModifiers check, ItemStack stack, int stage) {
        int count = 0;
        for (ISpellModifier modifier : this.getModifiersForStage(stack, stage)) {
            if (!modifier.getAspectsModified().contains((Object)check)) continue;
            ++count;
        }
        return count;
    }

    public int modifyDurationBasedOnArmor(EntityLivingBase caster, int baseDuration) {
        if (!(caster instanceof EntityPlayer)) {
            return baseDuration;
        }
        int armorSet = ArmorHelper.getFullArsMagicaArmorSet((EntityPlayer)caster);
        if (armorSet == ArsMagicaArmorMaterial.MAGE.getMaterialID()) {
            baseDuration = (int)((float)baseDuration * 1.25f);
        } else if (armorSet == ArsMagicaArmorMaterial.BATTLEMAGE.getMaterialID()) {
            baseDuration = (int)((float)baseDuration * 1.1f);
        } else if (armorSet == ArsMagicaArmorMaterial.ARCHMAGE.getMaterialID()) {
            baseDuration = (int)((float)baseDuration * 2.0f);
        }
        return baseDuration;
    }

    public SpellRequirements getSpellRequirements(ItemStack stack, EntityLivingBase caster) {
        if (!this.spellRequirementsPresent(stack, caster)) {
            this.writeSpellRequirements(stack, caster, this.calculateSpellRequirements(stack, caster));
        }
        return this.modifySpellRequirementsByAffinity(stack, caster, this.parseSpellRequirements(stack, caster));
    }

    public SpellRequirements modifySpellRequirementsByAffinity(ItemStack stack, EntityLivingBase caster, SpellRequirements reqs) {
        HashMap<Affinity, Float> affinities = this.AffinityFor(stack);
        AffinityData affData = AffinityData.For(caster);
        if (affData == null) {
            return reqs;
        }
        float manaCost = reqs.manaCost;
        for (Affinity aff : affinities.keySet()) {
            float depth = affData.getAffinityDepth(aff);
            float effectiveness = affinities.get((Object)aff).floatValue();
            float multiplier = 0.5f * depth;
            float manaMod = manaCost * effectiveness;
            manaCost -= manaMod * multiplier;
        }
        return new SpellRequirements(manaCost, reqs.burnout, reqs.reagents);
    }

    private SpellRequirements calculateSpellRequirements(ItemStack stack, EntityLivingBase caster) {
        float manaCost = 0.0f;
        float burnout = 0.0f;
        ArrayList<ItemStack> reagents = new ArrayList<ItemStack>();
        int stages = this.numStages(stack);
        for (int i = stages - 1; i >= 0; --i) {
            float stageManaCost = 0.0f;
            float stageBurnout = 0.0f;
            ISpellShape shape = this.getShapeForStage(stack, i);
            ISpellComponent[] components = this.getComponentsForStage(stack, i);
            ISpellModifier[] modifiers = this.getModifiersForStage(stack, i);
            for (ISpellComponent component : components) {
                ItemStack[] componentReagents = component.reagents(caster);
                if (componentReagents != null) {
                    for (ItemStack reagentStack : componentReagents) {
                        reagents.add(reagentStack);
                    }
                }
                stageManaCost += component.manaCost(caster);
                stageBurnout += component.burnout(caster);
            }
            HashMap<ISpellModifier, Integer> modifierWithQuantity = new HashMap<ISpellModifier, Integer>();
            for (ISpellModifier modifier : modifiers) {
                if (modifierWithQuantity.containsKey(modifier)) {
                    Integer qty = (Integer)modifierWithQuantity.get(modifier);
                    if (qty == null) {
                        qty = 1;
                    }
                    Integer n = qty;
                    Integer n2 = qty = Integer.valueOf(qty + 1);
                    modifierWithQuantity.put(modifier, qty);
                    continue;
                }
                modifierWithQuantity.put(modifier, 1);
            }
            for (ISpellModifier modifier : modifierWithQuantity.keySet()) {
                stageManaCost *= modifier.getManaCostMultiplier(stack, i, (Integer)modifierWithQuantity.get(modifier));
            }
            manaCost += stageManaCost * shape.manaCostMultiplier(stack);
            burnout += stageBurnout;
        }
        return new SpellRequirements(manaCost, burnout, reagents);
    }

    private SpellRequirements parseSpellRequirements(ItemStack stack, EntityLivingBase caster) {
        float burnoutPct = ExtendedProperties.For(caster).getCurrentFatigue() / ExtendedProperties.For(caster).getMaxFatigue() + 1.0f;
        float manaCost = stack.field_77990_d.func_74760_g(BaseManaCostIdentifier) * burnoutPct;
        float burnout = stack.field_77990_d.func_74760_g(BaseBurnoutIdentifier);
        int[] reagentList = stack.field_77990_d.func_74759_k(BaseReagentsIdentifier);
        ArrayList<ItemStack> reagents = new ArrayList<ItemStack>();
        for (int i = 0; i < reagentList.length; i += 3) {
            reagents.add(new ItemStack(Item.func_150899_d((int)reagentList[i]), reagentList[i + 1], reagentList[i + 2]));
        }
        return new SpellRequirements(manaCost, burnout, reagents);
    }

    private void writeSpellRequirements(ItemStack stack, EntityLivingBase caster, SpellRequirements requirements) {
        if (!stack.func_77942_o()) {
            return;
        }
        stack.field_77990_d.func_74776_a(BaseManaCostIdentifier, requirements.manaCost);
        stack.field_77990_d.func_74776_a(BaseBurnoutIdentifier, requirements.burnout);
        int[] reagentList = new int[requirements.reagents.size() * 3];
        int count = 0;
        for (ItemStack reagentStack : requirements.reagents) {
            reagentList[count++] = Item.func_150891_b((Item)reagentStack.func_77973_b());
            reagentList[count++] = reagentStack.field_77994_a;
            reagentList[count++] = reagentStack.func_77960_j();
        }
        stack.field_77990_d.func_74783_a(BaseReagentsIdentifier, reagentList);
        this.writeModVersionToStack(stack);
    }

    private boolean spellRequirementsPresent(ItemStack stack, EntityLivingBase caster) {
        if (!stack.func_77942_o()) {
            return false;
        }
        if (this.isOldVersionSpell(stack)) {
            return false;
        }
        return stack.field_77990_d.func_74764_b(BaseManaCostIdentifier) && stack.field_77990_d.func_74764_b(BaseBurnoutIdentifier) && stack.field_77990_d.func_74764_b(BaseReagentsIdentifier);
    }

    public int[] getShapeGroupParts(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.field_77990_d.func_74764_b(CurShapeGroup_Identifier)) {
            return new int[0];
        }
        int currentShapeGroup = stack.field_77990_d.func_74762_e(CurShapeGroup_Identifier);
        return stack.field_77990_d.func_74759_k(String.format("%s%d", ShapeGroup_Identifier, currentShapeGroup));
    }

    public int[] getShapeGroupParts(ItemStack stack, int index) {
        if (!stack.func_77942_o()) {
            return new int[0];
        }
        return stack.field_77990_d.func_74759_k(String.format("%s%d", ShapeGroup_Identifier, index));
    }

    public void setShapeGroup(ItemStack stack, int shapeGroup) {
        if (!stack.func_77942_o()) {
            return;
        }
        if (shapeGroup < 0 || shapeGroup >= stack.field_77990_d.func_74762_e(NumShapeGroups_Identifier)) {
            shapeGroup = 0;
        }
        stack.field_77990_d.func_74768_a(CurShapeGroup_Identifier, shapeGroup);
        this.changeEnchantmentsForShapeGroup(stack);
    }

    public int cycleShapeGroup(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        int current = stack.field_77990_d.func_74762_e(CurShapeGroup_Identifier);
        int max = stack.field_77990_d.func_74762_e(NumShapeGroups_Identifier);
        if (max == 0) {
            return 0;
        }
        return (current + 1) % max;
    }

    public void changeEnchantmentsForShapeGroup(ItemStack stack) {
        ItemStack constructed = this.constructSpellStack(stack);
        int looting = 0;
        int silkTouch = 0;
        for (int i = 0; i < instance.numStages(constructed); ++i) {
            looting += instance.countModifiers(SpellModifiers.FORTUNE_LEVEL, constructed, i);
            silkTouch += instance.countModifiers(SpellModifiers.SILKTOUCH_LEVEL, constructed, i);
        }
        AMEnchantmentHelper.fortuneStack(stack, looting);
        AMEnchantmentHelper.lootingStack(stack, looting);
        AMEnchantmentHelper.silkTouchStack(stack, silkTouch);
    }

    public void addShapeGroup(int[] shapeGroupParts, byte[][] metaDatas, ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        int numShapeGroups = stack.field_77990_d.func_74762_e(NumShapeGroups_Identifier) + 1;
        stack.field_77990_d.func_74768_a(NumShapeGroups_Identifier, numShapeGroups);
        stack.field_77990_d.func_74768_a(CurShapeGroup_Identifier, 0);
        stack.field_77990_d.func_74783_a(String.format("%s%d", ShapeGroup_Identifier, numShapeGroups - 1), shapeGroupParts);
        for (int i = 0; i < metaDatas.length; ++i) {
            stack.field_77990_d.func_74773_a(String.format("%s%d%d", ShapeGroupMeta_Identifier, numShapeGroups - 1, i), metaDatas[i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public ItemStack constructSpellStack(ItemStack stack) {
        int ordinal;
        HashMap<Integer, Integer> ordinals22;
        if (!stack.func_77942_o() || !stack.field_77990_d.func_74764_b(CurShapeGroup_Identifier)) {
            return stack.func_77946_l();
        }
        ItemStack classicStack = new ItemStack((Item)ItemsCommonProxy.spell);
        classicStack.func_77982_d(new NBTTagCompound());
        if (stack.field_77990_d.func_74764_b(Global_Spell_Meta)) {
            classicStack.field_77990_d.func_74782_a(Global_Spell_Meta, stack.field_77990_d.func_74781_a(Global_Spell_Meta));
        }
        int[] shapeGroup = this.getShapeGroupParts(stack);
        ArrayList<SpellStageDefinition> newStages = new ArrayList<SpellStageDefinition>();
        int currentShapeGroup = stack.field_77990_d.func_74762_e(CurShapeGroup_Identifier);
        int shapeGroupElementCount = 0;
        for (int n : shapeGroup) {
            ISkillTreeEntry entry = SkillManager.instance.getSkill(n);
            if (entry instanceof ISpellShape) {
                newStages.add(new SpellStageDefinition());
                ((SpellStageDefinition)newStages.get((int)(newStages.size() - 1))).shape = entry.getID();
            } else if (entry instanceof ISpellModifier) {
                void var12_22;
                byte[] byArray = stack.field_77990_d.func_74770_j(String.format("%s%d%d", ShapeGroupMeta_Identifier, currentShapeGroup, shapeGroupElementCount));
                if (byArray == null) {
                    byte[] byArray2 = new byte[]{};
                }
                ((SpellStageDefinition)newStages.get((int)(newStages.size() - 1))).definition.addModifier(SkillManager.instance.getShiftedPartID(entry), (byte[])var12_22);
            }
            ++shapeGroupElementCount;
        }
        if (this.numStages(stack) > 0 && newStages.size() > 0) {
            SpellStageDefinition last = (SpellStageDefinition)newStages.get(newStages.size() - 1);
            int firstShape = stack.field_77990_d.func_74762_e("ShapeOrdinal_0");
            if (firstShape == SkillManager.instance.missingShape.getID()) {
                int[] components = stack.field_77990_d.func_74759_k("SpellComponentIDs_0");
                ISpellModifier[] iSpellModifierArray = this.getModifiersForStage(stack, 0);
                for (Object i : (ISkillTreeEntry)components) {
                    last.definition.addComponent((int)i);
                }
                ordinals22 = new HashMap<Integer, Integer>();
                for (ISpellModifier modifier : iSpellModifierArray) {
                    ordinal = 0;
                    if (ordinals22.containsKey(modifier.getID())) {
                        ordinal = (Integer)ordinals22.get(modifier.getID());
                    }
                    last.definition.addModifier(modifier.getID() + 5000, this.getModifierMetadataFromStack(stack, modifier, 0, ordinal));
                }
            }
        }
        for (SpellStageDefinition stage : newStages) {
            this.addSpellStageToScroll(classicStack, stage.shape, stage.definition.getComponents(), stage.definition.getModifiers());
            ISkillTreeEntry components = SkillManager.instance.getSkill(stage.shape);
        }
        for (int i = 0; i < this.numStages(stack); ++i) {
            void var12_30;
            int[] components;
            SpellStageDefinition def = new SpellStageDefinition();
            def.shape = stack.field_77990_d.func_74762_e(Shape_Prefix + i);
            if (def.shape == SkillManager.instance.missingShape.getID()) continue;
            int[] nArray = components = stack.field_77990_d.func_74759_k(Component_Prefix + i);
            int ordinals22 = nArray.length;
            boolean bl = false;
            while (var12_30 < ordinals22) {
                int c = nArray[var12_30];
                def.definition.addComponent(c);
                ++var12_30;
            }
            ISpellModifier[] iSpellModifierArray = this.getModifiersForStage(stack, i);
            ordinals22 = new HashMap();
            for (ISpellModifier modifier : iSpellModifierArray) {
                ordinal = 0;
                if (ordinals22.containsKey(modifier.getID())) {
                    ordinal = (Integer)ordinals22.get(modifier.getID());
                }
                def.definition.addModifier(SkillManager.instance.getShiftedPartID(modifier), this.getModifierMetadataFromStack(stack, modifier, i, ordinal));
                ordinals22.put(modifier.getID(), ordinal++);
            }
            this.addSpellStageToScroll(classicStack, def.shape, def.definition.getComponents(), def.definition.getModifiers());
        }
        return classicStack;
    }

    public ItemStack popStackStage(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return stack;
        }
        ItemStack workingStack = stack.func_77946_l();
        int stages = this.numStages(workingStack);
        if (stages == 0) {
            return workingStack;
        }
        for (int i = 1; i < stages; ++i) {
            workingStack.field_77990_d.func_74783_a(Component_Prefix + (i - 1), workingStack.field_77990_d.func_74759_k(Component_Prefix + i));
            workingStack.field_77990_d.func_74783_a(Modifier_Prefix + (i - 1), workingStack.field_77990_d.func_74759_k(Modifier_Prefix + i));
            workingStack.field_77990_d.func_74768_a(Shape_Prefix + (i - 1), workingStack.field_77990_d.func_74762_e(Shape_Prefix + i));
        }
        workingStack.field_77990_d.func_74768_a(Stages_Identifier, stages - 1);
        workingStack.field_77990_d.func_82580_o(Component_Prefix + (stages - 1));
        workingStack.field_77990_d.func_82580_o(Modifier_Prefix + (stages - 1));
        workingStack.field_77990_d.func_82580_o(Shape_Prefix + (stages - 1));
        return workingStack;
    }

    public int numStages(ItemStack stack) {
        if (stack == null || !stack.func_77942_o()) {
            return 0;
        }
        int numStages = stack.field_77990_d.func_74764_b(Stages_Identifier) ? stack.field_77990_d.func_74762_e(Stages_Identifier) : stack.field_77990_d.func_74762_e(Shape_Prefix);
        return numStages;
    }

    public int numShapeGroups(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        return stack.field_77990_d.func_74762_e(NumShapeGroups_Identifier);
    }

    public ISpellComponent[] getComponentsForStage(ItemStack stack, int stage) {
        if (stack == null || !stack.func_77942_o()) {
            return new ISpellComponent[0];
        }
        int[] componentIDs = stack.field_77990_d.func_74759_k(Component_Prefix + stage);
        ISpellComponent[] components = new ISpellComponent[componentIDs.length];
        int count = 0;
        for (int i : componentIDs) {
            ISkillTreeEntry component = SkillManager.instance.getSkill(i);
            if (SkillTreeManager.instance.isSkillDisabled(component)) {
                components[count++] = SkillManager.instance.missingComponent;
                continue;
            }
            components[count++] = component != null && component instanceof ISpellComponent ? (ISpellComponent)component : SkillManager.instance.missingComponent;
        }
        return components;
    }

    public ISpellModifier[] getModifiersForStage(ItemStack stack, int stage) {
        if (stack == null || !stack.func_77942_o()) {
            return new ISpellModifier[0];
        }
        int[] modifierIDs = stack.field_77990_d.func_74759_k(Modifier_Prefix + stage);
        ISpellModifier[] modifiers = new ISpellModifier[modifierIDs.length];
        int count = 0;
        for (int i : modifierIDs) {
            ISkillTreeEntry modifier = SkillManager.instance.getSkill(i);
            if (SkillTreeManager.instance.isSkillDisabled(modifier)) {
                modifiers[count++] = SkillManager.instance.missingModifier;
                continue;
            }
            modifiers[count++] = modifier != null && modifier instanceof ISpellModifier ? (ISpellModifier)modifier : SkillManager.instance.missingModifier;
        }
        return modifiers;
    }

    public ISpellShape getShapeForStage(ItemStack stack, int stage) {
        if (stack == null || !stack.func_77942_o()) {
            return SkillManager.instance.missingShape;
        }
        int shapeIndex = stack.field_77990_d.func_74762_e(Shape_Prefix + stage);
        ISkillTreeEntry shape = SkillManager.instance.getSkill(shapeIndex);
        if (SkillTreeManager.instance.isSkillDisabled(shape)) {
            return SkillManager.instance.missingShape;
        }
        return shape != null && shape instanceof ISpellShape ? (ISpellShape)shape : SkillManager.instance.missingShape;
    }

    public boolean casterHasAllReagents(EntityLivingBase caster, ArrayList<ItemStack> reagents) {
        if (caster instanceof EntityPlayer && ((EntityPlayer)caster).field_71075_bZ.field_75098_d) {
            return true;
        }
        return true;
    }

    public boolean casterHasMana(EntityLivingBase caster, float mana) {
        if (caster instanceof EntityPlayer && ((EntityPlayer)caster).field_71075_bZ.field_75098_d) {
            return true;
        }
        return ExtendedProperties.For(caster).getCurrentMana() + ExtendedProperties.For(caster).getBonusCurrentMana() >= mana;
    }

    public void addSpellStageToScroll(ItemStack scrollStack, int shape, int[] components, ListMultimap<Integer, byte[]> modifiers) {
        if (scrollStack.field_77990_d == null) {
            scrollStack.field_77990_d = new NBTTagCompound();
        }
        int nextStage = this.numStages(scrollStack);
        scrollStack.field_77990_d.func_74768_a(Stages_Identifier, nextStage + 1);
        scrollStack.field_77990_d.func_74768_a(Shape_Prefix + nextStage, shape);
        scrollStack.field_77990_d.func_74783_a(Component_Prefix + nextStage, components);
        int[] modifierarray = new int[modifiers.values().size()];
        int index = 0;
        for (Integer modifierID : modifiers.keySet()) {
            int ordinalCount = 0;
            for (byte[] meta : modifiers.get((Object)modifierID)) {
                ISpellModifier modifier = SkillManager.instance.getModifier(modifierID);
                if (modifier == SkillManager.instance.missingModifier) continue;
                modifierarray[index++] = modifierID;
                if (meta == null) {
                    meta = new byte[]{};
                }
                this.writeModifierMetadataToStack(scrollStack, modifier, nextStage, ordinalCount++, meta);
            }
        }
        scrollStack.field_77990_d.func_74783_a(Modifier_Prefix + nextStage, modifierarray);
    }

    public Affinity mainAffinityFor(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return Affinity.NONE;
        }
        if (stack.field_77990_d.func_74764_b(ForcedAffinity)) {
            int aff = stack.field_77990_d.func_74762_e(ForcedAffinity);
            return Affinity.values()[aff];
        }
        HashMap<Integer, Integer> affinityFrequency = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.numStages(stack); ++i) {
            for (ISpellComponent comp : this.getComponentsForStage(stack, i)) {
                EnumSet<Affinity> affList = comp.getAffinity();
                for (Affinity affinity : affList) {
                    if (!affinityFrequency.containsKey(affinity.ordinal())) {
                        affinityFrequency.put(affinity.ordinal(), 1);
                        continue;
                    }
                    int old = (Integer)affinityFrequency.get(affinity.ordinal());
                    affinityFrequency.put(affinity.ordinal(), old + 1);
                }
            }
        }
        int highestCount = 0;
        int highestID = 0;
        for (Integer key : affinityFrequency.keySet()) {
            int count = (Integer)affinityFrequency.get(key);
            if (count <= highestCount) continue;
            highestID = key;
            highestCount = count;
        }
        return Affinity.values()[highestID];
    }

    public void doAffinityShift(EntityLivingBase caster, ISpellComponent component, ISpellShape governingShape) {
        if (!(caster instanceof EntityPlayer)) {
            return;
        }
        AffinityData aff = AffinityData.For(caster);
        EnumSet<Affinity> affList = component.getAffinity();
        for (Affinity affinity : affList) {
            float shift = component.getAffinityShift(affinity) * aff.getDiminishingReturnsFactor() * 5.0f;
            float xp = 0.05f * aff.getDiminishingReturnsFactor();
            if (governingShape.isChanneled()) {
                shift /= 4.0f;
                xp /= 4.0f;
            }
            if (caster instanceof EntityPlayer) {
                ItemStack chestArmor;
                if (SkillData.For((EntityPlayer)caster).isEntryKnown(SkillTreeManager.instance.getSkillTreeEntry(SkillManager.instance.getSkill("AffinityGains")))) {
                    shift *= 1.1f;
                    xp *= 0.9f;
                }
                if ((chestArmor = ((EntityPlayer)caster).func_82169_q(2)) != null && ArmorHelper.isInfusionPreset(chestArmor, "mg_xp")) {
                    xp *= 1.25f;
                }
            }
            if (shift > 0.0f) {
                AffinityChangingEvent event = new AffinityChangingEvent((EntityPlayer)caster, affinity, shift);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (!event.isCanceled()) {
                    aff.incrementAffinity(affinity, event.amount);
                }
            }
            if (!(xp > 0.0f)) continue;
            xp = (float)((double)xp * caster.func_110140_aT().func_111151_a(ArsMagicaApi.xpGainModifier).func_111126_e());
            ExtendedProperties.For(caster).addMagicXP(xp);
        }
        aff.addDiminishingReturns(governingShape.isChanneled());
    }

    public HashMap<Affinity, Float> AffinityFor(ItemStack stack) {
        HashMap<Affinity, Integer> affinityFrequency = new HashMap<Affinity, Integer>();
        HashMap<Affinity, Float> affinities = new HashMap<Affinity, Float>();
        float totalAffinityEntries = 0.0f;
        if (stack.field_77990_d.func_74764_b(ForcedAffinity)) {
            int aff = stack.field_77990_d.func_74762_e(ForcedAffinity);
            affinities.put(Affinity.values()[aff], Float.valueOf(100.0f));
            return affinities;
        }
        for (int i = 0; i < this.numStages(stack); ++i) {
            for (ISpellComponent comp : this.getComponentsForStage(stack, i)) {
                if (comp == SkillManager.instance.missingComponent) continue;
                EnumSet<Affinity> affList = comp.getAffinity();
                for (Affinity affinity : affList) {
                    totalAffinityEntries += 1.0f;
                    if (!affinityFrequency.containsKey((Object)affinity)) {
                        affinityFrequency.put(affinity, 1);
                        continue;
                    }
                    int old = (Integer)affinityFrequency.get((Object)affinity);
                    affinityFrequency.put(affinity, old + 1);
                }
            }
        }
        for (Affinity key : affinityFrequency.keySet()) {
            int count = (Integer)affinityFrequency.get((Object)key);
            float percent = totalAffinityEntries > 0.0f ? (float)count / totalAffinityEntries : 0.0f;
            affinities.put(key, Float.valueOf(percent));
        }
        return affinities;
    }

    public void addSpellStageToScroll(ItemStack scrollStack, String shape, String[] components, String[] modifiers) {
        int i;
        int spell_shape = SkillManager.instance.getShiftedPartID(SkillManager.instance.getSkill(shape));
        int[] spell_components = new int[components.length];
        ArrayListMultimap spell_modifiers = ArrayListMultimap.create();
        for (i = 0; i < spell_components.length; ++i) {
            if (components[i].equals("")) continue;
            spell_components[i] = SkillManager.instance.getShiftedPartID(SkillManager.instance.getSkill(components[i]));
        }
        for (i = 0; i < modifiers.length; ++i) {
            if (modifiers[i].equals("")) continue;
            int modifierID = SkillManager.instance.getShiftedPartID(SkillManager.instance.getSkill(modifiers[i]));
            byte[] meta = new byte[]{};
            spell_modifiers.put((Object)modifierID, (Object)meta);
        }
        this.addSpellStageToScroll(scrollStack, spell_shape, spell_components, (ListMultimap<Integer, byte[]>)spell_modifiers);
    }

    public float modifyDamage(EntityLivingBase caster, float damage) {
        float factor = (float)(ExtendedProperties.For(caster).getMagicLevel() < 20 ? 0.5 + 0.5 * (double)ExtendedProperties.For(caster).getMagicLevel() / 19.0 : 1.0 + 1.0 * (double)(ExtendedProperties.For(caster).getMagicLevel() - 20) / 79.0);
        return damage * factor;
    }

    public void writeModVersionToStack(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return;
        }
        stack.field_77990_d.func_74778_a("spell_mod_version", AMCore.instance.getVersion());
    }

    public void writeModifierMetadataToStack(ItemStack stack, ISpellModifier modifier, int stage, int ordinal, byte[] meta) {
        if (!stack.func_77942_o()) {
            return;
        }
        String identifier = String.format("%s%d_%d_%d", Modifier_Meta_Prefix, modifier.getID(), stage, ordinal);
        stack.field_77990_d.func_74773_a(identifier, meta);
    }

    public byte[] getModifierMetadataFromStack(ItemStack stack, ISpellModifier modifier, int stage, int ordinal) {
        if (!stack.func_77942_o()) {
            return new byte[0];
        }
        String identifier = String.format("%s%d_%d_%d", Modifier_Meta_Prefix, modifier.getID(), stage, ordinal);
        return stack.field_77990_d.func_74770_j(identifier);
    }

    public int getNextOrdinalForModifier(ItemStack stack, int stage, EnumSet<SpellModifiers> enumSet) {
        int ordinalCount = 0;
        for (ISpellModifier modifier : this.getModifiersForStage(stack, stage)) {
            if (!modifier.getAspectsModified().contains(enumSet)) continue;
            ++ordinalCount;
        }
        return ordinalCount;
    }

    public boolean isOldVersionSpell(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        String version = stack.field_77990_d.func_74779_i("spell_mod_version");
        return version != AMCore.instance.getVersion();
    }

    public boolean componentIsPresent(ItemStack stack, Class clazz, int stage) {
        ISpellComponent[] components;
        if (!stack.func_77942_o()) {
            return false;
        }
        for (ISpellComponent comp : components = this.getComponentsForStage(stack, stage)) {
            if (comp.getClass() != clazz) continue;
            return true;
        }
        return false;
    }

    public boolean spellIsChanneled(ItemStack stack) {
        ISpellShape shape = instance.getShapeForStage(stack, 0);
        if (this.numShapeGroups(stack) == 0 || !(shape instanceof MissingShape)) {
            return shape.isChanneled();
        }
        int[] parts = this.getShapeGroupParts(stack);
        ISpellShape finalShape = null;
        for (int i : parts) {
            ISkillTreeEntry entry = SkillManager.instance.getSkill(i);
            if (!(entry instanceof ISpellShape)) continue;
            finalShape = (ISpellShape)entry;
            break;
        }
        if (finalShape != null) {
            return finalShape.isChanneled();
        }
        return false;
    }

    public ItemStack createSpellStack(ArrayList<ArrayList<KeyValuePair<ISpellPart, byte[]>>> shapeGroups, ArrayList<KeyValuePair<ISpellPart, byte[]>> spell) {
        ArrayList recipeCopy = (ArrayList)spell.clone();
        if (recipeCopy.size() > 0 && !(((KeyValuePair)recipeCopy.get(0)).getKey() instanceof ISpellShape)) {
            recipeCopy.add(0, new KeyValuePair<ISpellShape, byte[]>(SkillManager.instance.missingShape, new byte[0]));
        }
        ItemStack stack = new ItemStack((Item)ItemsCommonProxy.spell);
        boolean hasSummon = false;
        while (recipeCopy.size() > 0) {
            ArrayList<Integer> components = new ArrayList<Integer>();
            ArrayListMultimap modifiers = ArrayListMultimap.create();
            KeyValuePair part = (KeyValuePair)recipeCopy.get(0);
            recipeCopy.remove(0);
            if (!(part.getKey() instanceof ISpellShape)) continue;
            ISpellShape shape = (ISpellShape)part.getKey();
            KeyValuePair keyValuePair = part = recipeCopy.size() > 0 ? (KeyValuePair)recipeCopy.get(0) : null;
            while (part != null && !(part.getKey() instanceof ISpellShape)) {
                recipeCopy.remove(0);
                if (part.getKey() instanceof ISpellComponent) {
                    components.add(SkillManager.instance.getShiftedPartID((ISkillTreeEntry)part.getKey()));
                    if (part.getKey() instanceof Summon) {
                        hasSummon = true;
                    }
                } else if (part.getKey() instanceof ISpellModifier) {
                    modifiers.put((Object)SkillManager.instance.getShiftedPartID((ISkillTreeEntry)part.getKey()), part.getValue());
                }
                part = recipeCopy.size() > 0 ? (KeyValuePair)recipeCopy.get(0) : null;
            }
            if (hasSummon) {
                ((Summon)SkillManager.instance.getSkill("Summon")).setSummonType(stack, EntitySkeleton.class);
            }
            instance.addSpellStageToScroll(stack, shape.getID(), this.ArrayListToIntArray(components), (ListMultimap<Integer, byte[]>)modifiers);
        }
        for (int i = 0; i < shapeGroups.size(); ++i) {
            ArrayList<KeyValuePair<ISpellPart, byte[]>> shapeGroup = shapeGroups.get(i);
            if (shapeGroup.size() == 0) continue;
            int[] sgp = new int[shapeGroup.size()];
            byte[][] sgp_m = new byte[shapeGroup.size()][];
            for (int n = 0; n < shapeGroup.size(); ++n) {
                sgp[n] = SkillManager.instance.getShiftedPartID(shapeGroup.get(n).getKey());
                sgp_m[n] = shapeGroup.get(n).getValue();
            }
            instance.addShapeGroup(sgp, sgp_m, stack);
        }
        instance.writeModVersionToStack(stack);
        ItemStack checkStack = this.constructSpellStack(stack);
        int silkTouchLevel = 0;
        int fortuneLevel = 0;
        for (int i = 0; i < this.numStages(checkStack); ++i) {
            int st = this.countModifiers(SpellModifiers.SILKTOUCH_LEVEL, checkStack, 0);
            int fn = this.countModifiers(SpellModifiers.FORTUNE_LEVEL, checkStack, 0);
            if (st > silkTouchLevel) {
                silkTouchLevel = st;
            }
            if (fn <= fortuneLevel) continue;
            fortuneLevel = fn;
        }
        if (fortuneLevel > 0) {
            AMEnchantmentHelper.fortuneStack(stack, fortuneLevel);
            AMEnchantmentHelper.lootingStack(stack, fortuneLevel);
        }
        if (silkTouchLevel > 0) {
            AMEnchantmentHelper.silkTouchStack(stack, silkTouchLevel);
        }
        return stack;
    }

    private int[] ArrayListToIntArray(ArrayList<Integer> list) {
        int[] arr = new int[list.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = list.get(i);
        }
        return arr;
    }

    public void setForcedAffinity(ItemStack stack, Affinity aff) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.field_77990_d.func_74768_a(ForcedAffinity, aff.ordinal());
    }

    public String getSpellMetadata(ItemStack stack, String key) {
        if (!stack.func_77942_o() || !stack.field_77990_d.func_74764_b(Global_Spell_Meta)) {
            return "";
        }
        NBTTagCompound metaComp = stack.field_77990_d.func_74775_l(Global_Spell_Meta);
        return metaComp.func_74779_i(key);
    }

    public void setSpellMetadata(ItemStack stack, String string, String s) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound meta = stack.field_77990_d.func_74775_l(Global_Spell_Meta);
        meta.func_74778_a(string, s);
        stack.field_77990_d.func_74782_a(Global_Spell_Meta, (NBTBase)meta);
    }

    public class SpellRequirements {
        public final float manaCost;
        public final float burnout;
        public final ArrayList<ItemStack> reagents;

        public SpellRequirements(float mana, float burnout, ArrayList<ItemStack> reagents) {
            this.manaCost = mana;
            this.burnout = burnout;
            this.reagents = reagents;
        }
    }
}

