/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.api.ArsMagicaApi;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.blocks.AMFlower;
import am2.blocks.BlocksCommonProxy;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleFloatUpward;
import am2.particles.ParticleOrbitPoint;
import am2.utility.DummyEntityPlayer;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.BonemealEvent;

public class Grow
implements ISpellComponent {
    private static final ArrayList<AMFlower> growableAMflowers = new ArrayList<AMFlower>(Arrays.asList(new AMFlower[]{BlocksCommonProxy.cerublossom, BlocksCommonProxy.desertNova, BlocksCommonProxy.wakebloom, BlocksCommonProxy.aum, BlocksCommonProxy.tarmaRoot}));

    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        IGrowable igrowable;
        Block block = world.func_147439_a(blockx, blocky, blockz);
        BonemealEvent event = new BonemealEvent(DummyEntityPlayer.fromEntityLiving(caster), world, block, blockx, blocky, blockz);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            return true;
        }
        if (world.field_73012_v.nextInt(100) < 3 && block.func_149721_r() && (world.func_147439_a(blockx, blocky + 1, blockz).isAir(null, 0, 0, 0) || world.func_147439_a(blockx, blocky + 1, blockz) == Blocks.field_150329_H)) {
            Collections.shuffle(growableAMflowers);
            for (AMFlower flower : growableAMflowers) {
                if (!flower.canGrowOn(world, blockx, blocky + 1, blockz)) continue;
                if (!world.field_72995_K) {
                    world.func_147465_d(blockx, blocky + 1, blockz, (Block)flower, 0, 2);
                }
                return true;
            }
        }
        if (block instanceof BlockMushroom) {
            if (!world.field_72995_K && world.field_73012_v.nextInt(10) < 1) {
                ((BlockMushroom)block).func_149884_c(world, blockx, blocky, blockz, world.field_73012_v);
            }
            return true;
        }
        if (block == Blocks.field_150355_j && world.func_147439_a(blockx, blocky + 1, blockz) == Blocks.field_150350_a) {
            if (!world.field_72995_K && world.field_73012_v.nextInt(100) < 3) {
                world.func_147449_b(blockx, blocky + 1, blockz, (Block)BlocksCommonProxy.wakebloom);
            }
            return true;
        }
        if (block == Blocks.field_150329_H && Blocks.field_150329_H.func_149718_j(world, blockx, blocky + 1, blockz)) {
            if (!world.field_72995_K && world.field_73012_v.nextInt(10) < 2) {
                world.func_147465_d(blockx, blocky, blockz, (Block)Blocks.field_150329_H, 1, 2);
            }
            return true;
        }
        if (block == Blocks.field_150330_I && Blocks.field_150329_H.func_149718_j(world, blockx, blocky, blockz)) {
            if (!world.field_72995_K && world.field_73012_v.nextInt(10) < 2) {
                world.func_147465_d(blockx, blocky, blockz, (Block)Blocks.field_150329_H, 1, 2);
            }
            return true;
        }
        if (block instanceof IGrowable && (igrowable = (IGrowable)block).func_149851_a(world, blockx, blocky, blockz, world.field_72995_K)) {
            if (!world.field_72995_K && world.field_73012_v.nextInt(10) < 3 && igrowable.func_149852_a(world, world.field_73012_v, blockx, blocky, blockz)) {
                igrowable.func_149853_b(world, world.field_73012_v, blockx, blocky, blockz);
            }
            return true;
        }
        return true;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        return false;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 17.4f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return ArsMagicaApi.getBurnoutFromMana(this.manaCost(caster));
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 25; ++i) {
            AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "plant", x + 0.5, y + 1.0, z + 0.5));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 1.0, 1.0);
            particle.AddParticleController(new ParticleFloatUpward(particle, 0.0f, 0.1f, 1, false));
            particle.AddParticleController(new ParticleOrbitPoint(particle, x + 0.5, y + 0.5, z + 0.5, 2, false).setIgnoreYCoordinate(true).SetOrbitSpeed(0.1f).SetTargetDistance((double)0.3f + rand.nextDouble() * 0.3));
            particle.AddParticleController(new ParticleFadeOut(particle, 1, false).setFadeSpeed(0.05f).setKillParticleOnFinish(true));
            particle.setMaxAge(20);
            particle.setParticleScale(0.1f);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.NATURE);
    }

    @Override
    public int getID() {
        return 22;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[3];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 6);
        objectArray[1] = new ItemStack(Items.field_151100_aR, 1, 15);
        objectArray[2] = BlocksCommonProxy.witchwoodLog;
        return objectArray;
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.02f;
    }
}

