/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.api.ArsMagicaApi;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.SpellModifiers;
import am2.buffs.BuffEffectRegeneration;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.ParticleFloatUpward;
import am2.particles.ParticleOrbitEntity;
import am2.playerextensions.ExtendedProperties;
import am2.spell.SpellUtils;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class Regeneration
implements ISpellComponent {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return false;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (target instanceof EntityLivingBase && ExtendedProperties.For((EntityLivingBase)target).getCanHeal()) {
            int duration = SpellUtils.instance.getModifiedInt_Mul(240, stack, caster, target, world, 0, SpellModifiers.DURATION);
            duration = SpellUtils.instance.modifyDurationBasedOnArmor(caster, duration);
            if (!world.field_72995_K) {
                ((EntityLivingBase)target).func_70690_d((PotionEffect)new BuffEffectRegeneration(duration, SpellUtils.instance.countModifiers(SpellModifiers.BUFF_POWER, stack, 0)));
            }
            ExtendedProperties.For((EntityLivingBase)target).setHealCooldown(60);
            return true;
        }
        return false;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 540.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return ArsMagicaApi.getBurnoutFromMana(this.manaCost(caster));
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 25; ++i) {
            AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "sparkle", x, y - 1.0, z));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 1.0, 1.0);
            particle.AddParticleController(new ParticleFloatUpward(particle, 0.0f, 0.1f, 1, false));
            particle.AddParticleController(new ParticleOrbitEntity(particle, target, 0.5, 2, false).setIgnoreYCoordinate(true).SetTargetDistance((double)0.3f + rand.nextDouble() * 0.3));
            particle.setMaxAge(20);
            particle.setParticleScale(0.2f);
            particle.setRGBColorF(0.1f, 1.0f, 0.8f);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.LIFE, Affinity.NATURE);
    }

    @Override
    public int getID() {
        return 46;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[2];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 2);
        objectArray[1] = Items.field_151153_ao;
        return objectArray;
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.05f;
    }
}

