/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.dynmap.ClientUpdateComponent;
import org.dynmap.ClientUpdateEvent;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.Event;
import org.dynmap.JSONUtils;
import org.dynmap.json.simple.JSONObject;
import org.dynmap.servlet.ClientUpdateServlet;
import org.dynmap.servlet.SendMessageServlet;

public class InternalClientUpdateComponent
extends ClientUpdateComponent {
    protected long jsonInterval;
    protected long currentTimestamp = 0L;
    protected long lastTimestamp = 0L;
    protected long lastChatTimestamp = 0L;
    private long last_confighash;
    private ConcurrentHashMap<String, JSONObject> updates = new ConcurrentHashMap();
    private JSONObject clientConfiguration = null;
    private static InternalClientUpdateComponent singleton;

    public InternalClientUpdateComponent(final DynmapCore dcore, ConfigurationNode configuration) {
        super(dcore, configuration);
        dcore.addServlet("/up/world/*", new ClientUpdateServlet(dcore));
        this.jsonInterval = (long)(configuration.getFloat("writeinterval", 1.0f) * 1000.0f);
        final Boolean allowwebchat = configuration.getBoolean("allowwebchat", false);
        final Boolean hidewebchatip = configuration.getBoolean("hidewebchatip", false);
        final Boolean trust_client_name = configuration.getBoolean("trustclientname", false);
        final float webchatInterval = configuration.getFloat("webchat-interval", 1.0f);
        final String spammessage = dcore.configuration.getString("spammessage", "You may only chat once every %interval% seconds.");
        final Boolean use_player_ip = configuration.getBoolean("use-player-login-ip", true);
        final Boolean req_player_ip = configuration.getBoolean("require-player-login-ip", false);
        final Boolean block_banned_player_chat = configuration.getBoolean("block-banned-player-chat", false);
        final Boolean req_login = configuration.getBoolean("webchat-requires-login", false);
        final Boolean chat_perm = configuration.getBoolean("webchat-permissions", false);
        final int length_limit = configuration.getInteger("chatlengthlimit", 256);
        final List<String> trustedproxy = dcore.configuration.getStrings("trusted-proxies", null);
        dcore.events.addListener("buildclientconfiguration", new Event.Listener<JSONObject>(){

            @Override
            public void triggered(JSONObject t) {
                JSONUtils.s(t, "allowwebchat", allowwebchat);
                JSONUtils.s(t, "webchat-interval", Float.valueOf(webchatInterval));
                JSONUtils.s(t, "webchat-requires-login", req_login);
                JSONUtils.s(t, "chatlengthlimit", length_limit);
            }
        });
        if (allowwebchat.booleanValue()) {
            SendMessageServlet messageHandler = new SendMessageServlet(){
                {
                    this.maximumMessageInterval = (int)(webchatInterval * 1000.0f);
                    this.spamMessage = "\"" + spammessage + "\"";
                    this.hideip = hidewebchatip;
                    this.trustclientname = trust_client_name;
                    this.use_player_login_ip = use_player_ip;
                    this.require_player_login_ip = req_player_ip;
                    this.check_user_ban = block_banned_player_chat;
                    this.require_login = req_login;
                    this.chat_perms = chat_perm;
                    this.lengthlimit = length_limit;
                    this.core = dcore;
                    if (trustedproxy != null) {
                        for (String s : trustedproxy) {
                            this.proxyaddress.add(s.trim());
                        }
                    } else {
                        this.proxyaddress.add("127.0.0.1");
                        this.proxyaddress.add("0:0:0:0:0:0:0:1");
                    }
                    this.onMessageReceived.addListener(new Event.Listener<SendMessageServlet.Message>(){

                        @Override
                        public void triggered(SendMessageServlet.Message t) {
                            core.webChat(t.name, t.message);
                        }
                    });
                }
            };
            dcore.addServlet("/up/sendmessage", messageHandler);
        }
        this.core.getServer().scheduleServerTask(new Runnable(){

            @Override
            public void run() {
                InternalClientUpdateComponent.this.currentTimestamp = System.currentTimeMillis();
                if (InternalClientUpdateComponent.this.last_confighash != (long)InternalClientUpdateComponent.this.core.getConfigHashcode()) {
                    InternalClientUpdateComponent.this.writeConfiguration();
                }
                InternalClientUpdateComponent.this.writeUpdates();
                InternalClientUpdateComponent.this.lastTimestamp = InternalClientUpdateComponent.this.currentTimestamp;
                InternalClientUpdateComponent.this.core.getServer().scheduleServerTask(this, InternalClientUpdateComponent.this.jsonInterval / 50L);
            }
        }, this.jsonInterval / 50L);
        this.core.events.addListener("initialized", new Event.Listener<Object>(){

            @Override
            public void triggered(Object t) {
                InternalClientUpdateComponent.this.writeConfiguration();
                InternalClientUpdateComponent.this.writeUpdates();
            }
        });
        this.core.events.addListener("worldactivated", new Event.Listener<DynmapWorld>(){

            @Override
            public void triggered(DynmapWorld t) {
                InternalClientUpdateComponent.this.writeConfiguration();
                InternalClientUpdateComponent.this.writeUpdates();
            }
        });
        this.writeConfiguration();
        this.writeUpdates();
        singleton = this;
    }

    protected void writeUpdates() {
        if (this.core.mapManager == null) {
            return;
        }
        for (DynmapWorld dynmapWorld : this.core.mapManager.getWorlds()) {
            JSONObject update = new JSONObject();
            update.put("timestamp", this.currentTimestamp);
            ClientUpdateEvent clientUpdate = new ClientUpdateEvent(this.currentTimestamp - 30000L, dynmapWorld, update);
            clientUpdate.include_all_users = true;
            this.core.events.trigger("buildclientupdate", clientUpdate);
            this.updates.put(dynmapWorld.getName(), update);
        }
    }

    protected void writeConfiguration() {
        JSONObject clientConfiguration = new JSONObject();
        this.core.events.trigger("buildclientconfiguration", clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.last_confighash = this.core.getConfigHashcode();
    }

    public static JSONObject getWorldUpdate(String wname) {
        if (singleton != null) {
            return InternalClientUpdateComponent.singleton.updates.get(wname);
        }
        return null;
    }

    public static JSONObject getClientConfig() {
        if (singleton != null) {
            return InternalClientUpdateComponent.singleton.clientConfiguration;
        }
        return null;
    }
}

