/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.forge;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.List;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.config.Configuration;
import org.dynmap.DynmapCommonAPI;
import org.dynmap.DynmapCommonAPIListener;
import org.dynmap.Log;
import org.dynmap.forge.DynmapPlugin;
import org.dynmap.forge.Proxy;
import org.dynmap.modsupport.ModSupportImpl;

@Mod(modid="Dynmap", name="Dynmap", version="2.6-beta-1-2035")
public class DynmapMod {
    @Mod.Instance(value="Dynmap")
    public static DynmapMod instance;
    @SidedProxy(clientSide="org.dynmap.forge.ClientProxy", serverSide="org.dynmap.forge.Proxy")
    public static Proxy proxy;
    public static DynmapPlugin plugin;
    public static File jarfile;
    public static boolean useforcedchunks;
    private boolean isMCPC;

    public DynmapMod() {
        Log.setLogger(new DynmapPlugin.OurLog());
        ModSupportImpl.init();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        jarfile = event.getSourceFile();
        Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
        try {
            cfg.load();
            useforcedchunks = cfg.get("Settings", "UseForcedChunks", true).getBoolean(true);
        }
        finally {
            cfg.save();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (useforcedchunks) {
            ForgeChunkManager.setForcedChunkLoadingCallback((Object)instance, (ForgeChunkManager.LoadingCallback)new LoadingCallback());
        } else {
            System.out.println("[Dynmap] World loading using forced chunks is disabled");
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        MinecraftServer ms = MinecraftServer.func_71276_C();
        boolean bl = this.isMCPC = ms != null && ms.getServerModName().contains("mcpc");
        if (this.isMCPC) {
            DynmapCommonAPIListener.register(new APICallback());
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        if (!this.isMCPC) {
            DynmapCommonAPIListener.register(new APICallback());
        }
        if (plugin == null) {
            plugin = proxy.startServer();
        }
        plugin.serverStarted();
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        proxy.stopServer(plugin);
        plugin = null;
    }

    @NetworkCheckHandler
    public boolean netCheckHandler(Map<String, String> mods, Side side) {
        return true;
    }

    public class LoadingCallback
    implements ForgeChunkManager.LoadingCallback {
        public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
            if (tickets.size() > 0) {
                DynmapPlugin.setBusy(world, tickets.get(0));
                for (int i = 1; i < tickets.size(); ++i) {
                    ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)tickets.get(i));
                }
            }
        }
    }

    public class APICallback
    extends DynmapCommonAPIListener {
        @Override
        public void apiListenerAdded() {
            if (plugin == null) {
                plugin = proxy.startServer();
            }
        }

        @Override
        public void apiEnabled(DynmapCommonAPI api) {
        }
    }
}

