/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class FenceGateBlockRenderer
extends CustomRenderer {
    private static final int TEXTURE_SIDES = 0;
    private static final int TEXTURE_TOP = 1;
    private static final int TEXTURE_BOTTOM = 2;
    private RenderPatch[][] meshes = new RenderPatch[8][];
    private static final int[] patchlist = new int[]{2, 1, 0, 0, 0, 0};

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        if (!super.initializeRenderer(rpf, blkid, blockdatamask, custparm)) {
            return false;
        }
        this.buildMeshes(rpf);
        return true;
    }

    @Override
    public int getMaximumTextureCount() {
        return 3;
    }

    private void addBox(RenderPatchFactory rpf, List<RenderPatch> list, double xmin, double xmax, double ymin, double ymax, double zmin, double zmax) {
        FenceGateBlockRenderer.addBox(rpf, list, xmin, xmax, ymin, ymax, zmin, zmax, patchlist);
    }

    private void buildMeshes(RenderPatchFactory rpf) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        for (int dat = 0; dat < 8; ++dat) {
            if ((dat & 1) == 0) {
                this.addBox(rpf, list, 0.0, 0.125, 0.3125, 1.0, 0.4375, 0.5625);
                this.addBox(rpf, list, 0.875, 1.0, 0.3125, 1.0, 0.4375, 0.5625);
                if ((dat & 4) == 0) {
                    this.addBox(rpf, list, 0.375, 0.625, 0.375, 0.9375, 0.4375, 0.5625);
                    this.addBox(rpf, list, 0.625, 0.875, 0.375, 0.5625, 0.4375, 0.5625);
                    this.addBox(rpf, list, 0.625, 0.875, 0.75, 0.9375, 0.4375, 0.5625);
                    this.addBox(rpf, list, 0.125, 0.375, 0.375, 0.5625, 0.4375, 0.5625);
                    this.addBox(rpf, list, 0.125, 0.375, 0.75, 0.9375, 0.4375, 0.5625);
                } else if ((dat & 3) == 0) {
                    this.addBox(rpf, list, 0.0, 0.125, 0.375, 0.9375, 0.8125, 0.9375);
                    this.addBox(rpf, list, 0.875, 1.0, 0.375, 0.9375, 0.8125, 0.9375);
                    this.addBox(rpf, list, 0.0, 0.125, 0.375, 0.5625, 0.5625, 0.8125);
                    this.addBox(rpf, list, 0.875, 1.0, 0.375, 0.5625, 0.5625, 0.8125);
                    this.addBox(rpf, list, 0.0, 0.125, 0.75, 0.9375, 0.5625, 0.8125);
                    this.addBox(rpf, list, 0.875, 1.0, 0.75, 0.9375, 0.5625, 0.8125);
                } else {
                    this.addBox(rpf, list, 0.0, 0.125, 0.375, 0.9375, 0.0625, 0.1875);
                    this.addBox(rpf, list, 0.875, 1.0, 0.375, 0.9375, 0.0625, 0.1875);
                    this.addBox(rpf, list, 0.0, 0.125, 0.375, 0.5625, 0.1875, 0.4375);
                    this.addBox(rpf, list, 0.875, 1.0, 0.375, 0.5625, 0.1875, 0.4375);
                    this.addBox(rpf, list, 0.0, 0.125, 0.75, 0.9375, 0.1875, 0.4375);
                    this.addBox(rpf, list, 0.875, 1.0, 0.75, 0.9375, 0.1875, 0.4375);
                }
            } else {
                this.addBox(rpf, list, 0.4375, 0.5625, 0.3125, 1.0, 0.0, 0.125);
                this.addBox(rpf, list, 0.4375, 0.5625, 0.3125, 1.0, 0.875, 1.0);
                if ((dat & 4) == 0) {
                    this.addBox(rpf, list, 0.4375, 0.5625, 0.375, 0.9375, 0.375, 0.625);
                    this.addBox(rpf, list, 0.4375, 0.5625, 0.375, 0.5625, 0.625, 0.875);
                    this.addBox(rpf, list, 0.4375, 0.5625, 0.75, 0.9375, 0.625, 0.875);
                    this.addBox(rpf, list, 0.4375, 0.5625, 0.375, 0.5625, 0.125, 0.375);
                    this.addBox(rpf, list, 0.4375, 0.5625, 0.75, 0.9375, 0.125, 0.375);
                } else if ((dat & 3) == 3) {
                    this.addBox(rpf, list, 0.8125, 0.9375, 0.375, 0.9375, 0.0, 0.125);
                    this.addBox(rpf, list, 0.8125, 0.9375, 0.375, 0.9375, 0.875, 1.0);
                    this.addBox(rpf, list, 0.5625, 0.8125, 0.375, 0.5625, 0.0, 0.125);
                    this.addBox(rpf, list, 0.5625, 0.8125, 0.375, 0.5625, 0.875, 1.0);
                    this.addBox(rpf, list, 0.5625, 0.8125, 0.75, 0.9375, 0.0, 0.125);
                    this.addBox(rpf, list, 0.5625, 0.8125, 0.75, 0.9375, 0.875, 1.0);
                } else {
                    this.addBox(rpf, list, 0.0625, 0.1875, 0.375, 0.9375, 0.0, 0.125);
                    this.addBox(rpf, list, 0.0625, 0.1875, 0.375, 0.9375, 0.875, 1.0);
                    this.addBox(rpf, list, 0.1875, 0.4375, 0.375, 0.5625, 0.0, 0.125);
                    this.addBox(rpf, list, 0.1875, 0.4375, 0.375, 0.5625, 0.875, 1.0);
                    this.addBox(rpf, list, 0.1875, 0.4375, 0.75, 0.9375, 0.0, 0.125);
                    this.addBox(rpf, list, 0.1875, 0.4375, 0.75, 0.9375, 0.875, 1.0);
                }
            }
            this.meshes[dat] = list.toArray(new RenderPatch[list.size()]);
            list.clear();
        }
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext ctx) {
        int meta = ctx.getBlockData();
        return this.meshes[meta & 7];
    }
}

