/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.jetty.http;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.dynmap.jetty.io.Buffer;
import org.dynmap.jetty.io.BufferCache;
import org.dynmap.jetty.util.StringUtil;
import org.dynmap.jetty.util.log.Log;
import org.dynmap.jetty.util.log.Logger;

public class MimeTypes {
    private static final Logger LOG;
    public static final String FORM_ENCODED = "application/x-www-form-urlencoded";
    public static final String MESSAGE_HTTP = "message/http";
    public static final String MULTIPART_BYTERANGES = "multipart/byteranges";
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String TEXT_XML = "text/xml";
    public static final String TEXT_JSON = "text/json";
    public static final String TEXT_HTML_8859_1 = "text/html;charset=ISO-8859-1";
    public static final String TEXT_PLAIN_8859_1 = "text/plain;charset=ISO-8859-1";
    public static final String TEXT_XML_8859_1 = "text/xml;charset=ISO-8859-1";
    public static final String TEXT_HTML_UTF_8 = "text/html;charset=UTF-8";
    public static final String TEXT_PLAIN_UTF_8 = "text/plain;charset=UTF-8";
    public static final String TEXT_XML_UTF_8 = "text/xml;charset=UTF-8";
    public static final String TEXT_JSON_UTF_8 = "text/json;charset=UTF-8";
    private static final String TEXT_HTML__8859_1 = "text/html; charset=ISO-8859-1";
    private static final String TEXT_PLAIN__8859_1 = "text/plain; charset=ISO-8859-1";
    private static final String TEXT_XML__8859_1 = "text/xml; charset=ISO-8859-1";
    private static final String TEXT_HTML__UTF_8 = "text/html; charset=UTF-8";
    private static final String TEXT_PLAIN__UTF_8 = "text/plain; charset=UTF-8";
    private static final String TEXT_XML__UTF_8 = "text/xml; charset=UTF-8";
    private static final String TEXT_JSON__UTF_8 = "text/json; charset=UTF-8";
    private static final int FORM_ENCODED_ORDINAL = 1;
    private static final int MESSAGE_HTTP_ORDINAL = 2;
    private static final int MULTIPART_BYTERANGES_ORDINAL = 3;
    private static final int TEXT_HTML_ORDINAL = 4;
    private static final int TEXT_PLAIN_ORDINAL = 5;
    private static final int TEXT_XML_ORDINAL = 6;
    private static final int TEXT_JSON_ORDINAL = 7;
    private static final int TEXT_HTML_8859_1_ORDINAL = 8;
    private static final int TEXT_PLAIN_8859_1_ORDINAL = 9;
    private static final int TEXT_XML_8859_1_ORDINAL = 10;
    private static final int TEXT_HTML_UTF_8_ORDINAL = 11;
    private static final int TEXT_PLAIN_UTF_8_ORDINAL = 12;
    private static final int TEXT_XML_UTF_8_ORDINAL = 13;
    private static final int TEXT_JSON_UTF_8_ORDINAL = 14;
    private static int __index;
    public static final BufferCache CACHE;
    public static final BufferCache.CachedBuffer FORM_ENCODED_BUFFER;
    public static final BufferCache.CachedBuffer MESSAGE_HTTP_BUFFER;
    public static final BufferCache.CachedBuffer MULTIPART_BYTERANGES_BUFFER;
    public static final BufferCache.CachedBuffer TEXT_HTML_BUFFER;
    public static final BufferCache.CachedBuffer TEXT_PLAIN_BUFFER;
    public static final BufferCache.CachedBuffer TEXT_XML_BUFFER;
    public static final BufferCache.CachedBuffer TEXT_JSON_BUFFER;
    public static final BufferCache.CachedBuffer TEXT_HTML_8859_1_BUFFER;
    public static final BufferCache.CachedBuffer TEXT_PLAIN_8859_1_BUFFER;
    public static final BufferCache.CachedBuffer TEXT_XML_8859_1_BUFFER;
    public static final BufferCache.CachedBuffer TEXT_HTML_UTF_8_BUFFER;
    public static final BufferCache.CachedBuffer TEXT_PLAIN_UTF_8_BUFFER;
    public static final BufferCache.CachedBuffer TEXT_XML_UTF_8_BUFFER;
    public static final BufferCache.CachedBuffer TEXT_JSON_UTF_8_BUFFER;
    public static final BufferCache.CachedBuffer TEXT_HTML__8859_1_BUFFER;
    public static final BufferCache.CachedBuffer TEXT_PLAIN__8859_1_BUFFER;
    public static final BufferCache.CachedBuffer TEXT_XML__8859_1_BUFFER;
    public static final BufferCache.CachedBuffer TEXT_HTML__UTF_8_BUFFER;
    public static final BufferCache.CachedBuffer TEXT_PLAIN__UTF_8_BUFFER;
    public static final BufferCache.CachedBuffer TEXT_XML__UTF_8_BUFFER;
    public static final BufferCache.CachedBuffer TEXT_JSON__UTF_8_BUFFER;
    private static final Map __dftMimeMap;
    private static final Map __encodings;
    private Map _mimeMap;

    public synchronized Map getMimeMap() {
        return this._mimeMap;
    }

    public void setMimeMap(Map mimeMap) {
        if (mimeMap == null) {
            this._mimeMap = null;
            return;
        }
        HashMap m = new HashMap();
        for (Map.Entry entry : mimeMap.entrySet()) {
            m.put(entry.getKey(), MimeTypes.normalizeMimeType(entry.getValue().toString()));
        }
        this._mimeMap = m;
    }

    public Buffer getMimeByExtension(String filename) {
        Buffer type = null;
        if (filename != null) {
            int i = -1;
            while (type == null && (i = filename.indexOf(".", i + 1)) >= 0 && i < filename.length()) {
                String ext = StringUtil.asciiToLowerCase(filename.substring(i + 1));
                if (this._mimeMap != null) {
                    type = (Buffer)this._mimeMap.get(ext);
                }
                if (type != null) continue;
                type = (Buffer)__dftMimeMap.get(ext);
            }
        }
        if (type == null) {
            if (this._mimeMap != null) {
                type = (Buffer)this._mimeMap.get("*");
            }
            if (type == null) {
                type = (Buffer)__dftMimeMap.get("*");
            }
        }
        return type;
    }

    public void addMimeMapping(String extension, String type) {
        if (this._mimeMap == null) {
            this._mimeMap = new HashMap();
        }
        this._mimeMap.put(StringUtil.asciiToLowerCase(extension), MimeTypes.normalizeMimeType(type));
    }

    private static synchronized Buffer normalizeMimeType(String type) {
        BufferCache.CachedBuffer b = CACHE.get(type);
        if (b == null) {
            b = CACHE.add(type, __index++);
        }
        return b;
    }

    public static String getCharsetFromContentType(Buffer value) {
        int i;
        if (value instanceof BufferCache.CachedBuffer) {
            switch (((BufferCache.CachedBuffer)value).getOrdinal()) {
                case 8: 
                case 9: 
                case 10: {
                    return "ISO-8859-1";
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    return "UTF-8";
                }
            }
        }
        int end = value.putIndex();
        int state = 0;
        int start = 0;
        boolean quote = false;
        block17: for (i = value.getIndex(); i < end; ++i) {
            byte b = value.peek(i);
            if (quote && state != 10) {
                if (34 != b) continue;
                quote = false;
                continue;
            }
            switch (state) {
                case 0: {
                    if (34 == b) {
                        quote = true;
                        continue block17;
                    }
                    if (59 != b) continue block17;
                    state = 1;
                    continue block17;
                }
                case 1: {
                    if (99 == b) {
                        state = 2;
                        continue block17;
                    }
                    if (32 == b) continue block17;
                    state = 0;
                    continue block17;
                }
                case 2: {
                    if (104 == b) {
                        state = 3;
                        continue block17;
                    }
                    state = 0;
                    continue block17;
                }
                case 3: {
                    if (97 == b) {
                        state = 4;
                        continue block17;
                    }
                    state = 0;
                    continue block17;
                }
                case 4: {
                    if (114 == b) {
                        state = 5;
                        continue block17;
                    }
                    state = 0;
                    continue block17;
                }
                case 5: {
                    if (115 == b) {
                        state = 6;
                        continue block17;
                    }
                    state = 0;
                    continue block17;
                }
                case 6: {
                    if (101 == b) {
                        state = 7;
                        continue block17;
                    }
                    state = 0;
                    continue block17;
                }
                case 7: {
                    if (116 == b) {
                        state = 8;
                        continue block17;
                    }
                    state = 0;
                    continue block17;
                }
                case 8: {
                    if (61 == b) {
                        state = 9;
                        continue block17;
                    }
                    if (32 == b) continue block17;
                    state = 0;
                    continue block17;
                }
                case 9: {
                    if (32 == b) continue block17;
                    if (34 == b) {
                        quote = true;
                        start = i + 1;
                        state = 10;
                        continue block17;
                    }
                    start = i;
                    state = 10;
                    continue block17;
                }
                case 10: {
                    if ((quote || 59 != b && 32 != b) && (!quote || 34 != b)) continue block17;
                    return CACHE.lookup(value.peek(start, i - start)).toString("UTF-8");
                }
            }
        }
        if (state == 10) {
            return CACHE.lookup(value.peek(start, i - start)).toString("UTF-8");
        }
        return (String)__encodings.get(value);
    }

    static {
        Enumeration<String> i;
        LOG = Log.getLogger(MimeTypes.class);
        __index = 15;
        CACHE = new BufferCache();
        FORM_ENCODED_BUFFER = CACHE.add(FORM_ENCODED, 1);
        MESSAGE_HTTP_BUFFER = CACHE.add(MESSAGE_HTTP, 2);
        MULTIPART_BYTERANGES_BUFFER = CACHE.add(MULTIPART_BYTERANGES, 3);
        TEXT_HTML_BUFFER = CACHE.add(TEXT_HTML, 4);
        TEXT_PLAIN_BUFFER = CACHE.add(TEXT_PLAIN, 5);
        TEXT_XML_BUFFER = CACHE.add(TEXT_XML, 6);
        TEXT_JSON_BUFFER = CACHE.add(TEXT_JSON, 7);
        TEXT_HTML_8859_1_BUFFER = CACHE.add(TEXT_HTML_8859_1, 8);
        TEXT_PLAIN_8859_1_BUFFER = CACHE.add(TEXT_PLAIN_8859_1, 9);
        TEXT_XML_8859_1_BUFFER = CACHE.add(TEXT_XML_8859_1, 10);
        TEXT_HTML_UTF_8_BUFFER = CACHE.add(TEXT_HTML_UTF_8, 11);
        TEXT_PLAIN_UTF_8_BUFFER = CACHE.add(TEXT_PLAIN_UTF_8, 12);
        TEXT_XML_UTF_8_BUFFER = CACHE.add(TEXT_XML_UTF_8, 13);
        TEXT_JSON_UTF_8_BUFFER = CACHE.add(TEXT_JSON_UTF_8, 14);
        TEXT_HTML__8859_1_BUFFER = CACHE.add(TEXT_HTML__8859_1, 8);
        TEXT_PLAIN__8859_1_BUFFER = CACHE.add(TEXT_PLAIN__8859_1, 9);
        TEXT_XML__8859_1_BUFFER = CACHE.add(TEXT_XML__8859_1, 10);
        TEXT_HTML__UTF_8_BUFFER = CACHE.add(TEXT_HTML__UTF_8, 11);
        TEXT_PLAIN__UTF_8_BUFFER = CACHE.add(TEXT_PLAIN__UTF_8, 12);
        TEXT_XML__UTF_8_BUFFER = CACHE.add(TEXT_XML__UTF_8, 13);
        TEXT_JSON__UTF_8_BUFFER = CACHE.add(TEXT_JSON__UTF_8, 14);
        __dftMimeMap = new HashMap();
        __encodings = new HashMap();
        try {
            ResourceBundle mime = ResourceBundle.getBundle("org/dynmap/jetty/http/mime");
            i = mime.getKeys();
            while (i.hasMoreElements()) {
                String ext = i.nextElement();
                String m = mime.getString(ext);
                __dftMimeMap.put(StringUtil.asciiToLowerCase(ext), MimeTypes.normalizeMimeType(m));
            }
        }
        catch (MissingResourceException e) {
            LOG.warn(e.toString(), new Object[0]);
            LOG.debug(e);
        }
        try {
            ResourceBundle encoding = ResourceBundle.getBundle("org/dynmap/jetty/http/encoding");
            i = encoding.getKeys();
            while (i.hasMoreElements()) {
                Buffer type = MimeTypes.normalizeMimeType(i.nextElement());
                __encodings.put(type, encoding.getString(type.toString()));
            }
        }
        catch (MissingResourceException e) {
            LOG.warn(e.toString(), new Object[0]);
            LOG.debug(e);
        }
        TEXT_HTML_BUFFER.setAssociate("ISO-8859-1", TEXT_HTML_8859_1_BUFFER);
        TEXT_HTML_BUFFER.setAssociate("ISO_8859_1", TEXT_HTML_8859_1_BUFFER);
        TEXT_HTML_BUFFER.setAssociate("iso-8859-1", TEXT_HTML_8859_1_BUFFER);
        TEXT_PLAIN_BUFFER.setAssociate("ISO-8859-1", TEXT_PLAIN_8859_1_BUFFER);
        TEXT_PLAIN_BUFFER.setAssociate("ISO_8859_1", TEXT_PLAIN_8859_1_BUFFER);
        TEXT_PLAIN_BUFFER.setAssociate("iso-8859-1", TEXT_PLAIN_8859_1_BUFFER);
        TEXT_XML_BUFFER.setAssociate("ISO-8859-1", TEXT_XML_8859_1_BUFFER);
        TEXT_XML_BUFFER.setAssociate("ISO_8859_1", TEXT_XML_8859_1_BUFFER);
        TEXT_XML_BUFFER.setAssociate("iso-8859-1", TEXT_XML_8859_1_BUFFER);
        TEXT_HTML_BUFFER.setAssociate("UTF-8", TEXT_HTML_UTF_8_BUFFER);
        TEXT_HTML_BUFFER.setAssociate("UTF8", TEXT_HTML_UTF_8_BUFFER);
        TEXT_HTML_BUFFER.setAssociate("utf8", TEXT_HTML_UTF_8_BUFFER);
        TEXT_HTML_BUFFER.setAssociate("utf-8", TEXT_HTML_UTF_8_BUFFER);
        TEXT_PLAIN_BUFFER.setAssociate("UTF-8", TEXT_PLAIN_UTF_8_BUFFER);
        TEXT_PLAIN_BUFFER.setAssociate("UTF8", TEXT_PLAIN_UTF_8_BUFFER);
        TEXT_PLAIN_BUFFER.setAssociate("utf8", TEXT_PLAIN_UTF_8_BUFFER);
        TEXT_PLAIN_BUFFER.setAssociate("utf-8", TEXT_PLAIN_UTF_8_BUFFER);
        TEXT_XML_BUFFER.setAssociate("UTF-8", TEXT_XML_UTF_8_BUFFER);
        TEXT_XML_BUFFER.setAssociate("UTF8", TEXT_XML_UTF_8_BUFFER);
        TEXT_XML_BUFFER.setAssociate("utf8", TEXT_XML_UTF_8_BUFFER);
        TEXT_XML_BUFFER.setAssociate("utf-8", TEXT_XML_UTF_8_BUFFER);
        TEXT_JSON_BUFFER.setAssociate("UTF-8", TEXT_JSON_UTF_8_BUFFER);
        TEXT_JSON_BUFFER.setAssociate("UTF8", TEXT_JSON_UTF_8_BUFFER);
        TEXT_JSON_BUFFER.setAssociate("utf8", TEXT_JSON_UTF_8_BUFFER);
        TEXT_JSON_BUFFER.setAssociate("utf-8", TEXT_JSON_UTF_8_BUFFER);
    }
}

