/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.jetty.server.handler;

import java.io.IOException;
import org.dynmap.javax.servlet.ServletException;
import org.dynmap.javax.servlet.http.HttpServletRequest;
import org.dynmap.javax.servlet.http.HttpServletResponse;
import org.dynmap.jetty.server.Handler;
import org.dynmap.jetty.server.Request;
import org.dynmap.jetty.server.Server;
import org.dynmap.jetty.server.handler.AbstractHandlerContainer;

public class HotSwapHandler
extends AbstractHandlerContainer {
    private volatile Handler _handler;

    public Handler getHandler() {
        return this._handler;
    }

    @Override
    public Handler[] getHandlers() {
        return new Handler[]{this._handler};
    }

    public void setHandler(Handler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Parameter handler is null.");
        }
        try {
            Handler old_handler = this._handler;
            this._handler = handler;
            Server server = this.getServer();
            handler.setServer(server);
            this.addBean(handler);
            if (server != null) {
                server.getContainer().update((Object)this, old_handler, handler, "handler");
            }
            if (old_handler != null) {
                this.removeBean(old_handler);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this._handler != null && this.isStarted()) {
            this._handler.handle(target, baseRequest, request, response);
        }
    }

    @Override
    public void setServer(Server server) {
        Server old_server = this.getServer();
        if (server == old_server) {
            return;
        }
        if (this.isRunning()) {
            throw new IllegalStateException("RUNNING");
        }
        super.setServer(server);
        Handler h = this.getHandler();
        if (h != null) {
            h.setServer(server);
        }
        if (server != null && server != old_server) {
            server.getContainer().update((Object)this, null, this._handler, "handler");
        }
    }

    protected Object expandChildren(Object list, Class byClass) {
        return this.expandHandler(this._handler, list, byClass);
    }

    @Override
    public void destroy() {
        if (!this.isStopped()) {
            throw new IllegalStateException("!STOPPED");
        }
        Handler child = this.getHandler();
        if (child != null) {
            this.setHandler(null);
            child.destroy();
        }
        super.destroy();
    }
}

