/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.servlet;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.imageio.ImageIO;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.MapType;
import org.dynmap.PlayerFaces;
import org.dynmap.javax.servlet.ServletException;
import org.dynmap.javax.servlet.ServletOutputStream;
import org.dynmap.javax.servlet.http.HttpServletRequest;
import org.dynmap.javax.servlet.http.HttpServletResponse;
import org.dynmap.jetty.server.Request;
import org.dynmap.jetty.server.handler.AbstractHandler;
import org.dynmap.storage.MapStorage;
import org.dynmap.storage.MapStorageTile;
import org.dynmap.utils.BufferInputStream;

public class MapStorageResourceHandler
extends AbstractHandler {
    private DynmapCore core;
    private byte[] blankpng;

    public MapStorageResourceHandler() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedImage blank = new BufferedImage(128, 128, 2);
        try {
            ImageIO.write((RenderedImage)blank, "png", baos);
            this.blankpng = baos.toByteArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String path = baseRequest.getPathInfo();
        int soff = 0;
        baseRequest.setHandled(true);
        if (path.charAt(0) == '/') {
            soff = 1;
        }
        int eoff = path.indexOf(47, soff);
        if (soff < 0) {
            response.sendError(404);
            return;
        }
        String world = path.substring(soff, eoff);
        String uri = path.substring(eoff + 1);
        if (world.equals("faces")) {
            this.handleFace(response, uri);
            return;
        }
        if (world.equals("_markers_")) {
            this.handleMarkers(response, uri);
            return;
        }
        DynmapWorld w = null;
        if (this.core.mapManager != null) {
            w = this.core.mapManager.getWorld(world);
        }
        if (w == null) {
            response.setContentType("image/png");
            ServletOutputStream os = response.getOutputStream();
            os.write(this.blankpng);
            return;
        }
        MapStorage store = w.getMapStorage();
        MapStorageTile tile = store.getTile(w, uri);
        if (tile == null) {
            response.setContentType("image/png");
            ServletOutputStream os = response.getOutputStream();
            os.write(this.blankpng);
            return;
        }
        MapStorageTile.TileRead tr = null;
        if (tile.getReadLock(5000L)) {
            tr = tile.read();
            tile.releaseReadLock();
        }
        if (tr == null) {
            response.setContentType("image/png");
            ServletOutputStream os = response.getOutputStream();
            os.write(this.blankpng);
            return;
        }
        response.setDateHeader("Last-Modified", tr.lastModified);
        response.setIntHeader("Content-Length", tr.image.length());
        response.setHeader("ETag", "\"" + tr.hashCode + "\"");
        if (tr.format == MapType.ImageEncoding.PNG) {
            response.setContentType("image/png");
        } else {
            response.setContentType("image/jpeg");
        }
        ServletOutputStream out = response.getOutputStream();
        out.write(tr.image.buffer(), 0, tr.image.length());
        out.flush();
    }

    private void handleFace(HttpServletResponse response, String uri) throws IOException, ServletException {
        String[] suri = uri.split("[/\\.]");
        if (suri.length < 3) {
            response.sendError(404);
            return;
        }
        PlayerFaces.FaceType ft = PlayerFaces.FaceType.byID(suri[0]);
        if (ft == null) {
            response.sendError(404);
            return;
        }
        BufferInputStream bis = null;
        if (this.core.playerfacemgr != null) {
            bis = this.core.playerfacemgr.storage.getPlayerFaceImage(suri[1], ft);
        }
        if (bis == null) {
            response.sendError(404);
            return;
        }
        response.setIntHeader("Content-Length", bis.length());
        response.setContentType("image/png");
        ServletOutputStream out = response.getOutputStream();
        out.write(bis.buffer(), 0, bis.length());
        out.flush();
    }

    private void handleMarkers(HttpServletResponse response, String uri) throws IOException, ServletException {
        String[] suri = uri.split("/");
        if (suri.length == 1 && suri[0].startsWith("marker_") && suri[0].endsWith(".json")) {
            String content = this.core.getDefaultMapStorage().getMarkerFile(suri[0].substring(7, suri[0].length() - 5));
            response.setContentType("application/json");
            PrintWriter pw = response.getWriter();
            pw.print(content);
            pw.flush();
            return;
        }
        if (suri[suri.length - 1].endsWith(".png")) {
            BufferInputStream bis = this.core.getDefaultMapStorage().getMarkerImage(uri.substring(0, uri.length() - 4));
            response.setIntHeader("Content-Length", bis.length());
            response.setContentType("image/png");
            ServletOutputStream out = response.getOutputStream();
            out.write(bis.buffer(), 0, bis.length());
            out.flush();
            return;
        }
        response.sendError(404);
    }

    public void setCore(DynmapCore core) {
        this.core = core;
    }
}

