/*
 * Decompiled with CFR 0.152.
 */
package com.wimbli.WorldBorder;

import com.wimbli.WorldBorder.BorderData;
import com.wimbli.WorldBorder.Config;
import com.wimbli.WorldBorder.CoordXZ;
import com.wimbli.WorldBorder.forge.Log;
import com.wimbli.WorldBorder.forge.Worlds;
import cpw.mods.fml.common.Loader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.World;
import org.dynmap.DynmapCommonAPI;
import org.dynmap.DynmapCommonAPIListener;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.CircleMarker;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerSet;

public class DynMapFeatures {
    private static final int LINE_WEIGHT = 3;
    private static final double LINE_OPACITY = 1.0;
    private static final int LINE_COLOR = 0xFF0000;
    private static boolean enabled = false;

    public static void registerListener() {
        enabled = Loader.isModLoaded((String)"Dynmap");
        if (enabled) {
            Gateway.register();
        } else {
            Log.debug("Dynmap is not available; integration disabled", new Object[0]);
        }
    }

    public static void renderRegion(World world, CoordXZ coord) {
        if (!enabled) {
            return;
        }
        int y = world != null ? world.func_72800_K() : 255;
        int x = CoordXZ.regionToBlock(coord.x);
        int z = CoordXZ.regionToBlock(coord.z);
        Gateway.api.triggerRenderOfVolume(Worlds.getWorldName(world), x, 0, z, x + 511, y, z + 511);
    }

    public static void renderChunks(World world, List<CoordXZ> coords) {
        if (!enabled) {
            return;
        }
        int y = world != null ? world.func_72800_K() : 255;
        for (CoordXZ coord : coords) {
            DynMapFeatures.renderChunk(Worlds.getWorldName(world), coord, y);
        }
    }

    public static void renderChunk(String worldName, CoordXZ coord, int maxY) {
        if (!enabled) {
            return;
        }
        int x = CoordXZ.chunkToBlock(coord.x);
        int z = CoordXZ.chunkToBlock(coord.z);
        Gateway.api.triggerRenderOfVolume(worldName, x, 0, z, x + 15, maxY, z + 15);
    }

    public static void showAllBorders() {
        if (!enabled) {
            return;
        }
        DynMapFeatures.removeAllBorders();
        if (!Config.isDynmapBorderEnabled()) {
            if (Gateway.markSet != null) {
                Gateway.markSet.deleteMarkerSet();
            }
            Gateway.markSet = null;
            return;
        }
        Gateway.markSet = Gateway.markApi.getMarkerSet("worldborder.markerset");
        if (Gateway.markSet == null) {
            Gateway.markSet = Gateway.markApi.createMarkerSet("worldborder.markerset", "WorldBorder", null, false);
        } else {
            Gateway.markSet.setMarkerSetLabel("WorldBorder");
        }
        Map<String, BorderData> borders = Config.getBorders();
        for (Map.Entry<String, BorderData> stringBorderDataEntry : borders.entrySet()) {
            String worldName = stringBorderDataEntry.getKey();
            BorderData border = stringBorderDataEntry.getValue();
            DynMapFeatures.showBorder(worldName, border);
        }
    }

    public static void showBorder(String worldName, BorderData border) {
        if (!enabled) {
            return;
        }
        if (!Config.isDynmapBorderEnabled()) {
            return;
        }
        if (border.getShape() == null ? Config.getShapeRound() : border.getShape() != false) {
            DynMapFeatures.showRoundBorder(worldName, border);
        } else {
            DynMapFeatures.showSquareBorder(worldName, border);
        }
    }

    private static void showRoundBorder(String worldName, BorderData border) {
        CircleMarker marker;
        if (Gateway.squareBorders.containsKey(worldName)) {
            DynMapFeatures.removeBorder(worldName);
        }
        if ((marker = (CircleMarker)Gateway.roundBorders.get(worldName)) == null) {
            marker = Gateway.markSet.createCircleMarker("worldborder_" + worldName, Config.getDynmapMessage(), false, worldName, border.getX(), 64.0, border.getZ(), (double)border.getRadiusX(), (double)border.getRadiusZ(), true);
            marker.setLineStyle(3, 1.0, 0xFF0000);
            marker.setFillStyle(0.0, 0);
            Gateway.roundBorders.put(worldName, marker);
        } else {
            marker.setCenter(worldName, border.getX(), 64.0, border.getZ());
            marker.setRadius((double)border.getRadiusX(), (double)border.getRadiusZ());
        }
    }

    private static void showSquareBorder(String worldName, BorderData border) {
        if (Gateway.roundBorders.containsKey(worldName)) {
            DynMapFeatures.removeBorder(worldName);
        }
        double[] xVals = new double[]{border.getX() - (double)border.getRadiusX(), border.getX() + (double)border.getRadiusX()};
        double[] zVals = new double[]{border.getZ() - (double)border.getRadiusZ(), border.getZ() + (double)border.getRadiusZ()};
        AreaMarker marker = (AreaMarker)Gateway.squareBorders.get(worldName);
        if (marker == null) {
            marker = Gateway.markSet.createAreaMarker("worldborder_" + worldName, Config.getDynmapMessage(), false, worldName, xVals, zVals, true);
            marker.setLineStyle(3, 1.0, 0xFF0000);
            marker.setFillStyle(0.0, 0);
            Gateway.squareBorders.put(worldName, marker);
        } else {
            marker.setCornerLocations(xVals, zVals);
        }
    }

    public static void removeAllBorders() {
        if (!enabled) {
            return;
        }
        for (CircleMarker marker : Gateway.roundBorders.values()) {
            marker.deleteMarker();
        }
        Gateway.roundBorders.clear();
        for (CircleMarker marker : Gateway.squareBorders.values()) {
            marker.deleteMarker();
        }
        Gateway.squareBorders.clear();
    }

    public static void removeBorder(String worldName) {
        AreaMarker marker2;
        if (!enabled) {
            return;
        }
        CircleMarker marker = (CircleMarker)Gateway.roundBorders.remove(worldName);
        if (marker != null) {
            marker.deleteMarker();
        }
        if ((marker2 = (AreaMarker)Gateway.squareBorders.remove(worldName)) != null) {
            marker2.deleteMarker();
        }
    }

    private static class Gateway {
        private static DynmapCommonAPI api;
        private static MarkerAPI markApi;
        private static MarkerSet markSet;
        private static Map<String, CircleMarker> roundBorders;
        private static Map<String, AreaMarker> squareBorders;
        private static DynmapCommonAPIListener listener;

        private Gateway() {
        }

        public static void register() {
            DynmapCommonAPIListener.register((DynmapCommonAPIListener)listener);
        }

        static {
            roundBorders = new HashMap<String, CircleMarker>();
            squareBorders = new HashMap<String, AreaMarker>();
            listener = new DynmapCommonAPIListener(){

                public void apiEnabled(DynmapCommonAPI dynmapCommonAPI) {
                    api = dynmapCommonAPI;
                    markApi = api.getMarkerAPI();
                    DynMapFeatures.showAllBorders();
                    Log.info("Successfully hooked into Dynmap for the ability to display borders", new Object[0]);
                }
            };
        }
    }
}

