/*
 * Decompiled with CFR 0.152.
 */
package com.wimbli.WorldBorder.cmd;

import com.wimbli.WorldBorder.Config;
import com.wimbli.WorldBorder.cmd.WBCmd;
import com.wimbli.WorldBorder.forge.Util;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;

public class CmdShape
extends WBCmd {
    public CmdShape() {
        this.permission = "shape";
        this.name = "shape";
        this.maxParams = 1;
        this.minParams = 1;
        this.addCmdExample(this.nameEmphasized() + "<round|square> - set the default border shape.");
        this.addCmdExample(this.nameEmphasized() + "<elliptic|rectangular> - same as above.");
        this.helpText = "Default value: round/elliptic. The default border shape will be used on all worlds which don't have an individual shape set using the " + this.commandEmphasized("wshape") + C_DESC + "command. Elliptic " + "and round work the same, as rectangular and square do. The difference is down to whether the X and Z " + "radius are the same.";
    }

    @Override
    public void cmdStatus(ICommandSender sender) {
        Util.chat(sender, C_HEAD + "The default border shape for all worlds is currently set to \"" + Config.getShapeName() + "\".", new Object[0]);
    }

    @Override
    public void execute(ICommandSender sender, EntityPlayerMP player, List<String> params, String worldName) {
        String shape = params.get(0).toLowerCase();
        if (shape.equals("rectangular") || shape.equals("square")) {
            Config.setShape(false);
        } else if (shape.equals("elliptic") || shape.equals("round")) {
            Config.setShape(true);
        } else {
            this.sendErrorAndHelp(sender, "You must specify one of the 4 valid shape names below.");
            return;
        }
        if (player != null) {
            this.cmdStatus(sender);
        }
    }
}

